/*
 * Decompiled with CFR 0.152.
 */
package com.askfast.askfastapi;

import com.askfast.askfastapi.model.Answer;
import com.askfast.askfastapi.model.EventPost;
import com.askfast.askfastapi.model.MediaProperty;
import com.askfast.askfastapi.model.Question;
import com.askfast.askfastapi.util.HttpUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.message.types.GrantType;

public class AskFast {
    private static final Logger log = Logger.getLogger(AskFast.class.getName());
    private String ASKFAST_JSONRPC = "http://live.ask-fast.com/dialoghandler/agents/dialog";
    private String ASKFAST_KEYSERVER = "http://live.ask-fast.com/keyserver/token";
    private Question question = null;
    private String baseURL = null;
    private String accountID = null;
    private String bearerToken = null;
    private String refreshToken = null;
    private Map<String, String> params = new HashMap<String, String>();

    public AskFast() {
        this("", null, null, null);
    }

    public AskFast(HttpServletRequest req) {
        this(AskFast.getHost(req));
    }

    public AskFast(String url) {
        this(url, null, null, null);
    }

    public AskFast(HttpServletRequest req, String accountID, String refreshToken, Map<String, String> params) {
        this(AskFast.getHost(req), accountID, refreshToken, params);
    }

    public AskFast(String url, String accountID, String refreshToken, Map<String, String> params) {
        this.baseURL = url;
        this.accountID = accountID;
        this.refreshToken = refreshToken;
        this.params = params;
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        if (this.question == null) {
            this.question = new Question();
        }
    }

    @JsonIgnore
    public String getQuestionId() {
        return this.question.getQuestion_id();
    }

    @JsonIgnore
    public Question getQuestion() {
        return this.question;
    }

    public void say(String value) {
        this.say(value, null);
    }

    public void say(String value, String next) {
        value = this.formatText(value);
        next = this.formatURL(next);
        this.question.setType("comment");
        this.question.setQuestion_text(value);
        if (next != null) {
            this.question.addAnswer(new Answer(null, next));
        }
    }

    public void ask(String ask) {
        this.ask(ask, "");
    }

    public void askByVoice(String ask, String next) {
        this.ask(ask, "", next);
        this.addMediaProperty(MediaProperty.MediumType.BROADSOFT, MediaProperty.MediaPropertyKey.TYPE, "audio");
    }

    public void ask(String ask, String next) {
        this.ask(ask, null, next);
    }

    public void ask(String ask, String answerText, String next) {
        this.ask(ask, answerText, next, "open");
    }

    public void exit(String exitURL) {
        this.question.setType("exit");
        this.question.setQuestion_text(exitURL);
    }

    public void conference(String ask, String next) {
        this.ask(ask, null, next, "conference");
    }

    public void ask(String ask, AskFast askFast) {
        this.ask(ask, null, null);
        this.question.addAnswer(new Answer("", askFast.question.getQuestion_id()));
    }

    public void addAnswer(String answer, String next) {
        this.question.setType("closed");
        answer = this.formatText(answer);
        next = this.formatURL(next);
        this.question.addAnswer(new Answer(answer, next));
    }

    public void addAnswer(String answer, AskFast askFast) {
        this.question.setType("closed");
        answer = this.formatText(answer);
        this.question.addAnswer(new Answer(answer, askFast.question.getQuestion_id()));
    }

    public void redirect(String to) {
        this.redirect(to, null, null);
    }

    public void redirect(String to, String redirectText) {
        this.redirect(to, redirectText, null);
    }

    public void redirect(String to, String redirectText, String next) {
        this.question.setType("referral");
        this.question.setUrl(to);
        if (redirectText != null) {
            redirectText = this.formatText(redirectText);
            this.question.setQuestion_text(redirectText);
        }
        if (next != null) {
            next = this.formatURL(next);
            this.question.addAnswer(new Answer(null, next));
        }
    }

    public void redirect(String to, String redirectText, String next, String preconnectURL) {
        this.question.setType("referral");
        this.question.setUrl(to);
        if (redirectText != null) {
            redirectText = this.formatText(redirectText);
            this.question.setQuestion_text(redirectText);
        }
        if (next != null) {
            next = this.formatURL(next);
            this.question.addAnswer(new Answer(null, next));
        }
        if (preconnectURL != null && !preconnectURL.isEmpty()) {
            this.question.addEvent_callbacks(EventPost.EventType.preconnect, preconnectURL);
            this.question.addProperty(MediaProperty.MediumType.BROADSOFT, MediaProperty.MediaPropertyKey.USE_PRECONNECT, "true");
        }
    }

    public String render() {
        return this.question.toJSON();
    }

    public String outBoundCall(String fromAddress, String toAddress, String url) throws Exception {
        return this.outBoundCall(fromAddress, null, toAddress, null, url);
    }

    public String outBoundCall(String fromAddress, String toAddress, String subject, String url) throws Exception {
        return this.outBoundCall(fromAddress, null, toAddress, subject, url);
    }

    public String outBoundCall(String fromAddress, String senderName, String toAddress, String subject, String url) throws Exception {
        return this.outBoundCall(fromAddress, senderName, Arrays.asList(toAddress), subject, url);
    }

    public String outBoundCall(String fromAddress, String senderName, Collection<String> toAddressList, String subject, String url) throws Exception {
        HashMap<String, String> toAddressMap = new HashMap<String, String>();
        for (String toAddress : toAddressList) {
            toAddressMap.put(toAddress, "");
        }
        return this.outBoundCall(fromAddress, senderName, toAddressMap, subject, url);
    }

    public String outBoundCall(String fromAddress, String senderName, Map<String, String> toAddressNameMap, String url) throws Exception {
        return this.outBoundCall(fromAddress, senderName, toAddressNameMap, null, url);
    }

    public String outBoundCall(String fromAddress, String senderName, Map<String, String> toAddressNameMap, String subject, String url) throws Exception {
        return this.outBoundCall(fromAddress, senderName, toAddressNameMap, null, null, subject, url);
    }

    public String outBoundCall(String fromAddress, String senderName, Map<String, String> toAddressNameMap, Map<String, String> ccAddressNameMap, Map<String, String> bccAddressNameMap, String subject, String url) throws Exception {
        ObjectNode json;
        if (this.bearerToken == null) {
            this.obtainAccessToken();
        }
        if (this.accountID == null || this.bearerToken == null) {
            throw new Exception("AccountID or BearerToken isn't set, please obtainAccessToken() first!");
        }
        log.info(String.format("request received to initiate outbound call. From: %s To: %s Cc: %s and Bcc: %s using URL: %s", fromAddress, toAddressNameMap, ccAddressNameMap, bccAddressNameMap, url));
        url = this.formatURL(url);
        ObjectMapper om = new ObjectMapper();
        ObjectNode body = om.createObjectNode();
        body.put("id", UUID.randomUUID().toString());
        body.put("method", "outboundCallWithMap");
        ObjectNode params = om.createObjectNode();
        params.put("adapterID", fromAddress);
        params.putPOJO("addressMap", (Object)om.writeValueAsString(toAddressNameMap));
        if (ccAddressNameMap != null && !ccAddressNameMap.isEmpty()) {
            params.putPOJO("addressCcMap", (Object)om.writeValueAsString(ccAddressNameMap));
        }
        if (bccAddressNameMap != null && !bccAddressNameMap.isEmpty()) {
            params.putPOJO("addressBccMap", (Object)om.writeValueAsString(bccAddressNameMap));
        }
        params.put("url", url);
        params.put("senderName", senderName);
        params.put("accountID", this.accountID);
        params.put("bearerToken", this.bearerToken);
        params.put("subject", subject);
        body.set("params", (JsonNode)params);
        log.info(String.format("request initiated for outbound call at: %s with payload: %s", this.ASKFAST_JSONRPC, body.toString()));
        String res = HttpUtil.post(this.ASKFAST_JSONRPC, body.toString());
        if ((res != null && res.startsWith("{") || res.trim().startsWith("{")) && (json = (ObjectNode)om.readValue(res, ObjectNode.class)).has("error") && json.get("error").get("message").textValue().equals("Invalid token given")) {
            throw new Exception("Please re-obtain AccessToken!");
        }
        log.info(String.format("outbound call response recieved: %s", res));
        return res;
    }

    public void addEvent(EventPost.EventType eventType, String callbackURL) {
        callbackURL = this.formatURL(callbackURL);
        this.question.addEvent_callbacks(eventType, callbackURL);
    }

    public void addMediaProperty(MediaProperty.MediumType mediumType, MediaProperty.MediaPropertyKey propertyKey, String value) {
        MediaProperty mediaProperty = new MediaProperty();
        mediaProperty.setMedium(mediumType);
        mediaProperty.addProperty(propertyKey, value);
        this.question.addMediaProperties(mediaProperty);
    }

    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    public String obtainAccessToken() throws Exception {
        if (this.accountID == null || this.refreshToken == null) {
            throw new Exception("AccountID or ResfreshToken isn't set.");
        }
        OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)this.ASKFAST_KEYSERVER).setGrantType(GrantType.REFRESH_TOKEN).setClientId(this.accountID).setClientSecret("blabla").setRefreshToken(this.refreshToken).buildQueryMessage();
        OAuthJSONAccessTokenResponse response = oAuthClient.accessToken(request);
        if (response.getAccessToken() != null) {
            this.bearerToken = response.getAccessToken();
            return this.bearerToken;
        }
        return null;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public void setPreferredLanguage(String language) {
        this.question.setPreferred_language(language);
    }

    public void render(HttpServletResponse response) throws IOException {
        String json = this.render();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(json);
        response.getWriter().flush();
        response.getWriter().close();
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    private String formatText(String text) {
        if (text == null) {
            return null;
        }
        if (!text.startsWith("http") && !text.startsWith("https")) {
            if (text.endsWith(".wav")) {
                if (this.baseURL != null) {
                    text = String.valueOf(this.baseURL) + text;
                }
            } else if (!text.startsWith("dtmfKey://")) {
                text = "text://" + text;
            }
        }
        return text;
    }

    private String formatURL(String url) {
        if (url == null || url.isEmpty()) {
            return url;
        }
        if (!url.startsWith("http") && !url.startsWith("https") && this.baseURL != null) {
            url = String.valueOf(this.baseURL) + url;
        }
        url = this.addQueryString(url);
        return url;
    }

    private String addQueryString(String url) {
        if (this.params.size() > 0) {
            String query = "?";
            if (url.contains("?")) {
                query = "&";
            }
            Iterator<Map.Entry<String, String>> it = this.params.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    Map.Entry<String, String> param = it.next();
                    query = String.valueOf(query) + param.getKey() + "=" + URLEncoder.encode(param.getValue(), "UTF-8") + "&";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return String.valueOf(url) + query.substring(0, query.length() - 1);
        }
        return url;
    }

    private static String getHost(HttpServletRequest req) {
        int port = req.getServerPort();
        if (req.getScheme().equals("http") && port == 80) {
            port = -1;
        } else if (req.getScheme().equals("https") && port == 443) {
            port = -1;
        }
        String url = null;
        try {
            URL serverURL = new URL(req.getScheme(), req.getServerName(), port, "");
            url = serverURL.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    private void ask(String ask, String answerText, String answerCallback, String askType) {
        ask = this.formatText(ask);
        answerCallback = this.formatURL(answerCallback);
        answerText = answerText != null ? answerText : "";
        this.question.setQuestion_text(ask);
        this.question.setType(askType);
        if (answerCallback != null && !answerCallback.isEmpty()) {
            this.question.setAnswers(new ArrayList<Answer>(Arrays.asList(new Answer(answerText, answerCallback))));
        }
    }

    public String getASKFAST_JSONRPC() {
        return this.ASKFAST_JSONRPC;
    }

    public void setASKFAST_JSONRPC(String aSKFAST_JSONRPC) {
        this.ASKFAST_JSONRPC = aSKFAST_JSONRPC;
    }

    public String getASKFAST_KEYSERVER() {
        return this.ASKFAST_KEYSERVER;
    }

    public void setASKFAST_KEYSERVER(String aSKFAST_KEYSERVER) {
        this.ASKFAST_KEYSERVER = aSKFAST_KEYSERVER;
    }
}

