/*
 * Decompiled with CFR 0.152.
 */
package com.askfast.model;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum Language {
    CATALAN("ca-es"),
    CHINESE("zh-cn"),
    CHINESE_HONGKONG("zh-hk"),
    CHINESE_TAIWAN("zh-tw"),
    DANISH("da-dk"),
    DUTCH("nl-nl", "nl"),
    ENGLISH_AUSTRALIA("en-au"),
    ENGLISH_CANADA("en-ca"),
    ENGLISH_GREATBRITAIN("en-gb"),
    ENGLISH_INDIA("en-in"),
    ENGLISH_UNITEDSTATES("en-us", "en"),
    FINNISH("fi-fi"),
    FRENCH_CANADA("fr-ca"),
    FRENCH_FRANCE("fr-fr"),
    GERMAN("de-de"),
    ITALIAN("it-it"),
    JAPANESE("ja-jp"),
    KOREAN("ko-kr"),
    NORWEGIAN("nb-no"),
    POLISH("pl-pl"),
    PORTUGUESE_BRAZIL("pt-br"),
    PORTUGUESE_PORTUGAL("pt-pt"),
    RUSSIAN("ru-ru"),
    SPANISH_MEXICO("es-mx"),
    SPANISH_SPAIN("es-es"),
    SWEDISH_SWEDEN("sv-se");

    String code = null;
    String secondaryCode = null;

    private Language(String languageCode) {
        this(languageCode, null);
    }

    private Language(String languageCode, String secondaryLangCode) {
        this.code = languageCode;
        this.secondaryCode = secondaryLangCode;
    }

    public String getCode() {
        return this.code;
    }

    public String getSecondaryCode() {
        return this.secondaryCode;
    }

    public static Language getByValue(String nameOrValue) {
        Language[] languageArray = Language.values();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language type = languageArray[n2];
            if (type.getCode().equalsIgnoreCase(nameOrValue) || type.name().equalsIgnoreCase(nameOrValue) || type.getSecondaryCode() != null && type.getSecondaryCode().equals(nameOrValue)) {
                return type;
            }
            ++n2;
        }
        return DUTCH;
    }

    @JsonCreator
    public static Language fromJson(String name) {
        return Language.getByValue(name);
    }
}

