/*
 * Decompiled with CFR 0.152.
 */
package com.askfast.askfastapi;

import com.askfast.askfastapi.AskFastRestClient;
import com.askfast.askfastapi.model.Answer;
import com.askfast.askfastapi.model.EventPost;
import com.askfast.askfastapi.model.MediaProperty;
import com.askfast.askfastapi.model.Question;
import com.askfast.model.Result;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.URIBuilder;

public class AskFast {
    private static final Logger log = Logger.getLogger(AskFast.class.getName());
    private Question question = null;
    private String baseURL = null;
    private String accountID = null;
    private String bearerToken = null;
    private String refreshToken = null;
    private Map<String, String> params = new HashMap<String, String>();

    public AskFast() {
        this("", null, null, null);
    }

    public AskFast(HttpServletRequest req) {
        this(AskFast.getHost(req));
    }

    public AskFast(String url) {
        this(url, null, null, null);
    }

    public AskFast(HttpServletRequest req, String accountID, String refreshToken, Map<String, String> params) {
        this(AskFast.getHost(req), accountID, refreshToken, params);
    }

    public AskFast(String url, String accountID, String refreshToken, Map<String, String> params) {
        this.baseURL = url;
        this.accountID = accountID;
        this.refreshToken = refreshToken;
        this.params = params;
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        if (this.question == null) {
            this.question = new Question();
        }
    }

    @JsonIgnore
    public String getQuestionId() {
        return this.question.getQuestion_id();
    }

    @JsonIgnore
    public Question getQuestion() {
        return this.question;
    }

    public void say(String value) {
        this.say(value, null);
    }

    public void say(String value, String next) {
        value = this.formatText(value);
        next = this.formatURL(next);
        this.question.setType("comment");
        this.question.setQuestion_text(value);
        if (next != null) {
            this.question.addAnswer(new Answer(null, next));
        }
    }

    public void ask(String ask) {
        this.ask(ask, "");
    }

    public void askByVoice(String ask, String next) {
        this.ask(ask, "", next);
        this.addMediaProperty(MediaProperty.MediumType.BROADSOFT, MediaProperty.MediaPropertyKey.TYPE, "audio");
    }

    public void ask(String ask, String next) {
        this.ask(ask, null, next);
    }

    public void ask(String ask, String answerText, String next) {
        this.ask(ask, answerText, next, "open");
    }

    public void exit(String exitURL) {
        this.question.setType("exit");
        this.question.setQuestion_text(exitURL);
    }

    public void reject() {
        this.question.setType("reject");
    }

    public void conference(String ask, String next) {
        this.ask(ask, null, next, "conference");
    }

    public void addAnswer(String answer, String next) {
        this.question.setType("closed");
        answer = this.formatText(answer);
        next = this.formatURL(next);
        this.question.addAnswer(new Answer(answer, next));
    }

    public void redirect(String to) {
        this.redirect(to, null, null, null);
    }

    public void redirect(String to, String redirectText) {
        this.redirect(to, redirectText, null, null);
    }

    public void redirect(String to, String redirectText, String next) {
        this.redirect(to, redirectText, next, null);
    }

    public void redirect(String to, String redirectText, String next, String preconnectURL) {
        this.question.setType("referral");
        to = this.formatPhoneUrl(to);
        this.question.setUrl(Arrays.asList(to));
        if (redirectText != null) {
            redirectText = this.formatText(redirectText);
            this.question.setQuestion_text(redirectText);
        }
        if (next != null) {
            next = this.formatURL(next);
            this.question.addAnswer(new Answer(null, next));
        }
        if (preconnectURL != null && !preconnectURL.isEmpty()) {
            this.question.addEvent_callbacks(EventPost.EventType.preconnect, preconnectURL);
            this.question.addProperty(MediaProperty.MediumType.BROADSOFT, MediaProperty.MediaPropertyKey.USE_PRECONNECT, "true");
        }
    }

    public void redirect(List<String> addresses, String redirectText, String next, String preconnectURL) {
        this.question.setType("referral");
        ArrayList<String> formatedAddresses = new ArrayList<String>();
        for (String address : addresses) {
            formatedAddresses.add(this.formatPhoneUrl(address));
        }
        this.question.setUrl(formatedAddresses);
        if (redirectText != null) {
            redirectText = this.formatText(redirectText);
            this.question.setQuestion_text(redirectText);
        }
        if (next != null) {
            next = this.formatURL(next);
            this.question.addAnswer(new Answer(null, next));
        }
        if (preconnectURL != null && !preconnectURL.isEmpty()) {
            this.question.addEvent_callbacks(EventPost.EventType.preconnect, preconnectURL);
            this.question.addProperty(MediaProperty.MediumType.BROADSOFT, MediaProperty.MediaPropertyKey.USE_PRECONNECT, "true");
        }
    }

    public String render() {
        return this.question.toJSON();
    }

    @Deprecated
    public String outBoundCall(String fromAddress, String toAddress, String url) throws Exception {
        return this.outBoundCall(fromAddress, null, toAddress, null, url);
    }

    public String outBoundCall(String fromAddress, String toAddress, String subject, String url) throws Exception {
        return this.outBoundCall(fromAddress, null, toAddress, subject, url);
    }

    public String outBoundCall(String fromAddress, String senderName, String toAddress, String subject, String url) throws Exception {
        return this.outBoundCall(fromAddress, senderName, Arrays.asList(toAddress), subject, url);
    }

    public String outBoundCall(String fromAddress, String senderName, Collection<String> toAddressList, String subject, String url) throws Exception {
        HashMap<String, String> toAddressMap = new HashMap<String, String>();
        for (String toAddress : toAddressList) {
            toAddressMap.put(toAddress, "");
        }
        return this.outBoundCall(fromAddress, senderName, toAddressMap, subject, url);
    }

    public String outBoundCall(String fromAddress, String senderName, Map<String, String> toAddressNameMap, String url) throws Exception {
        return this.outBoundCall(fromAddress, senderName, toAddressNameMap, null, url);
    }

    public String outBoundCall(String fromAddress, String senderName, Map<String, String> toAddressNameMap, String subject, String url) throws Exception {
        return this.outBoundCall(fromAddress, senderName, toAddressNameMap, null, null, subject, url);
    }

    public String outBoundCall(String fromAddress, String senderName, Map<String, String> toAddressNameMap, Map<String, String> ccAddressNameMap, Map<String, String> bccAddressNameMap, String subject, String url) throws Exception {
        if (this.accountID == null || this.refreshToken == null) {
            throw new Exception("AccountID or refreshToken isn't set. " + this.accountID);
        }
        log.info(String.format("request received to initiate outbound call. From: %s To: %s Cc: %s and Bcc: %s using URL: %s", fromAddress, toAddressNameMap, ccAddressNameMap, bccAddressNameMap, url));
        url = this.formatURL(url);
        AskFastRestClient afrc = new AskFastRestClient(this.accountID, this.refreshToken);
        Result result = afrc.startDialog(toAddressNameMap, ccAddressNameMap, bccAddressNameMap, null, fromAddress, senderName, subject, url);
        if (result.getCode() != 200) {
            throw new Exception("startDialog failed: " + result.getCode() + " " + result.getMessage() + " " + result.getResult());
        }
        String res = result.getResult().toString();
        log.info(String.format("outbound call response recieved: %s", res));
        return res;
    }

    public void addEvent(EventPost.EventType eventType, String callbackURL) {
        callbackURL = this.formatURL(callbackURL);
        this.question.addEvent_callbacks(eventType, callbackURL);
    }

    public void addMediaProperty(MediaProperty.MediumType mediumType, MediaProperty.MediaPropertyKey propertyKey, String value) {
        MediaProperty mediaProperty = new MediaProperty();
        mediaProperty.setMedium(mediumType);
        mediaProperty.addProperty(propertyKey, value);
        this.question.addMediaProperties(mediaProperty);
    }

    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public void setPreferredLanguage(String language) {
        this.question.setPreferred_language(language);
    }

    public void render(HttpServletResponse response) throws IOException {
        String json = this.render();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(json);
        response.getWriter().flush();
        response.getWriter().close();
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    private String formatText(String text) {
        if (text == null) {
            return null;
        }
        if (!text.startsWith("http") && !text.startsWith("https")) {
            if (text.endsWith(".wav") && this.baseURL != null && !this.baseURL.isEmpty()) {
                text = this.baseURL + text;
            } else if (!text.startsWith("dtmfKey://")) {
                text = "text://" + text;
            }
        }
        return text;
    }

    private String formatPhoneUrl(String url) {
        if (!(url == null || url.startsWith("http") || url.startsWith("tel:") || url.startsWith("client:"))) {
            url = "tel:" + url;
        }
        return url;
    }

    protected String formatURL(String url) {
        if (url == null || url.isEmpty()) {
            return url;
        }
        if (!(url.startsWith("http") || url.startsWith("https") || this.baseURL == null || this.baseURL.isEmpty())) {
            url = this.baseURL + url;
        }
        url = this.addQueryString(url);
        return url;
    }

    private String addQueryString(String url) {
        if (this.params != null && !this.params.isEmpty()) {
            try {
                url = url.replace(" ", "%20");
                URIBuilder uriBuilder = new URIBuilder(new URI(url));
                for (String queryKey : this.params.keySet()) {
                    uriBuilder.addParameter(queryKey, this.params.get(queryKey));
                }
                return uriBuilder.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    private static String getHost(HttpServletRequest req) {
        int port = req.getServerPort();
        if (req.getScheme().equals("http") && port == 80) {
            port = -1;
        } else if (req.getScheme().equals("https") && port == 443) {
            port = -1;
        }
        String url = null;
        try {
            URL serverURL = new URL(req.getScheme(), req.getServerName(), port, "");
            url = serverURL.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    private void ask(String ask, String answerText, String answerCallback, String askType) {
        ask = this.formatText(ask);
        answerCallback = this.formatURL(answerCallback);
        answerText = answerText != null ? answerText : "";
        this.question.setQuestion_text(ask);
        this.question.setType(askType);
        if (answerCallback != null && !answerCallback.isEmpty()) {
            this.question.setAnswers(new ArrayList<Answer>(Arrays.asList(new Answer(answerText, answerCallback))));
        }
    }
}

