/*
 * Decompiled with CFR 0.152.
 */
package com.askfast.askfastapi;

import com.askfast.askfastapi.model.ModifyCall;
import com.askfast.model.Adapter;
import com.askfast.model.AdapterType;
import com.askfast.model.DDRRecord;
import com.askfast.model.Dialog;
import com.askfast.model.DialogRequest;
import com.askfast.model.Recording;
import com.askfast.model.RestResponse;
import com.askfast.model.Result;
import com.askfast.util.AskFastRestService;
import com.askfast.util.JSONUtil;
import com.askfast.util.JacksonConverter;
import com.squareup.okhttp.OkHttpClient;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;

public class AskFastRestClient {
    public static final String DEFAULT_ENDPOINT = "https://api.ask-fast.com";
    public static final String KEYSERVER_PATH = "/keyserver/token";
    private String accountId = null;
    private String refreshToken = null;
    private String accessToken = null;
    private String endpoint = null;
    private static final ThreadLocal<String> request_host = new ThreadLocal();

    public AskFastRestClient(String accountId, String refreshToken) {
        this(accountId, refreshToken, null);
    }

    public AskFastRestClient(String accountId, String refreshToken, String accessToken) {
        this(accountId, refreshToken, accessToken, null);
    }

    public AskFastRestClient(String accountId, String refreshToken, String accessToken, String endpoint) {
        this.accountId = accountId;
        this.refreshToken = refreshToken;
        this.accessToken = accessToken;
        this.endpoint = endpoint;
        if (endpoint == null) {
            this.endpoint = DEFAULT_ENDPOINT;
        }
    }

    public Result startPhoneDialog(String toAddress, String url) {
        return this.startDialog(toAddress, AdapterType.CALL, null, null, url);
    }

    public Result startSMSDialog(String toAddress, String senderName, String url) {
        return this.startDialog(toAddress, AdapterType.SMS, senderName, null, url);
    }

    public Result startEmailDialog(String toAddress, String senderName, String subject, String url) {
        return this.startDialog(toAddress, AdapterType.EMAIL, senderName, subject, url);
    }

    public Result startDialog(String toAddress, String adapterId, String senderName, String subject, String url) {
        AskFastRestService service = this.getRestService();
        return service.startDialog(new DialogRequest(toAddress, null, adapterId, senderName, subject, url));
    }

    public Result startDialog(String toAddress, AdapterType adapterType, String senderName, String subject, String url) {
        AskFastRestService service = this.getRestService();
        return service.startDialog(new DialogRequest(toAddress, adapterType, null, senderName, subject, url));
    }

    public Result startDialog(Map<String, String> addressMap, Map<String, String> addressCcMap, Map<String, String> addressBccMap, AdapterType adapterType, String adapterID, String senderName, String subject, String url) {
        AskFastRestService service = this.getRestService();
        return service.startDialog(new DialogRequest(addressMap, addressCcMap, addressBccMap, adapterType, adapterID, senderName, subject, url));
    }

    public Set<Adapter> getAdapters(String type) {
        AskFastRestService service = this.getRestService();
        return AskFastRestClient.asOrderedSet(service.getAdapters(type, true));
    }

    public Set<Adapter> getAllAdapters(String type) {
        AskFastRestService service = this.getRestService();
        return AskFastRestClient.asOrderedSet(service.getAdapters(type, false));
    }

    protected static <T> Set<T> asOrderedSet(List<T> src) {
        LinkedHashSet<T> ret = new LinkedHashSet<T>();
        for (int i = 0; i < src.size(); ++i) {
            ret.add(src.get(i));
        }
        return ret;
    }

    public Adapter getAdapter(String adapterId) {
        return this.getRestService().getAdapter(adapterId);
    }

    public Adapter updateAdapter(String adapterId, Adapter adapter) {
        AskFastRestService service = this.getRestService();
        return service.updateAdapter(adapterId, adapter);
    }

    public void buyAdapter(String adapterId) {
        AskFastRestService service = this.getRestService();
        service.buyAdapter(adapterId);
    }

    public void removeAdapter(String adapterId) {
        AskFastRestService service = this.getRestService();
        service.removeAdapter(adapterId);
    }

    public Set<Adapter> getFreeAdapters(String adapterType, String address) {
        AskFastRestService service = this.getRestService();
        return service.getFreeAdapters(adapterType, address);
    }

    public List<Adapter> getCapableAdapters(String type) {
        AskFastRestService service = this.getRestService();
        return service.getCapableAdapters(type);
    }

    public Dialog createDialog(Dialog dialog) {
        AskFastRestService service = this.getRestService();
        return service.createDialog(dialog);
    }

    public Set<Dialog> getDialogs() {
        AskFastRestService service = this.getRestService();
        return service.getDialogs();
    }

    public Set<Dialog> getDialogsByName(String name) {
        AskFastRestService service = this.getRestService();
        return service.getDialogsByName(name);
    }

    public Dialog getDialog(String dialogId) {
        AskFastRestService service = this.getRestService();
        return service.getDialog(dialogId);
    }

    public Dialog updateDialog(String dialogId, Dialog dialog) {
        AskFastRestService service = this.getRestService();
        return service.updateDialog(dialogId, dialog);
    }

    public void removeDialog(String dialogId) {
        AskFastRestService service = this.getRestService();
        service.removeDialog(dialogId);
    }

    public List<Recording> getRecordings() {
        return this.getRecordings(this.accountId);
    }

    public List<Recording> getRecordings(String accountId) {
        if (accountId == null) {
            throw new IllegalArgumentException("No accountId given");
        }
        AskFastRestService service = this.getRestService();
        return service.getRecordings(accountId);
    }

    public List<DDRRecord> getDDRRecords(Collection<String> adapterIds, Collection<String> adapterTypes, String fromAddress, String typeId, String status, Long startTime, Long endTime, String delimitedSessionKeys, Integer offset, Integer limit, Boolean shouldGenerateCosts, Boolean shouldIncludeServiceCosts) throws Exception {
        AskFastRestService service = this.getRestService();
        String delimitedAdapterIds = null;
        String delimitedAdapterTypes = null;
        if (adapterIds != null) {
            delimitedAdapterIds = JSONUtil.toCDLString(adapterIds);
        }
        if (adapterTypes != null) {
            delimitedAdapterTypes = JSONUtil.toCDLString(adapterTypes);
        }
        return service.getDDRRecords(delimitedAdapterIds, delimitedAdapterTypes, fromAddress, typeId, status, startTime, endTime, delimitedSessionKeys, offset, limit, shouldGenerateCosts, shouldIncludeServiceCosts);
    }

    public Integer getDDRRecordCount(Collection<String> adapterIds, Collection<String> adapterTypes, String fromAddress, String typeId, String status, Long startTime, Long endTime, String delimitedSessionKeys, Integer offset) throws Exception {
        RestResponse ddrRecordsCountResponse;
        AskFastRestService service = this.getRestService();
        String delimitedAdapterIds = null;
        String delimitedAdapterTypes = null;
        if (adapterIds != null) {
            delimitedAdapterIds = JSONUtil.toCDLString(adapterIds);
        }
        if (adapterTypes != null) {
            delimitedAdapterTypes = JSONUtil.toCDLString(adapterTypes);
        }
        if ((ddrRecordsCountResponse = service.getDDRRecordsCount(delimitedAdapterIds, delimitedAdapterTypes, fromAddress, typeId, status, startTime, endTime, delimitedSessionKeys, offset)) != null && ddrRecordsCountResponse.getCode() == 200) {
            return (Integer)ddrRecordsCountResponse.getResult();
        }
        throw new Exception(ddrRecordsCountResponse.getMessage());
    }

    public RestResponse modifyCall(String sessionId, String url) {
        AskFastRestService service = this.getRestService();
        ModifyCall mc = new ModifyCall();
        mc.setSessionId(sessionId);
        mc.setUrl(url);
        return service.modifyCall(mc);
    }

    public RestResponse redirectCallToAnotherNumber(String sessionId, String number) {
        String url = "https://api.ask-fast.com/question/redirection?address=" + number;
        return this.modifyCall(sessionId, url);
    }

    private RestAdapter getRestAdapter() {
        return new RestAdapter.Builder().setRequestInterceptor(new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                try {
                    String token = AskFastRestClient.this.getAccessToken();
                    request.addHeader("Authorization", "Bearer " + token);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).setEndpoint(this.endpoint).setConverter((Converter)new JacksonConverter()).setClient((Client)new OkClient(new OkHttpClient())).build();
    }

    private AskFastRestService getRestService() {
        RestAdapter adapter = this.getRestAdapter();
        return (AskFastRestService)adapter.create(AskFastRestService.class);
    }

    public String getAccessToken() throws Exception {
        if (this.accessToken != null) {
            return this.accessToken;
        }
        return this.refreshAccessToken();
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    private String refreshAccessToken() throws Exception {
        if (this.accountId == null) {
            throw new Exception("AccountID isn't set.");
        }
        if (this.refreshToken == null) {
            throw new Exception("Refresh Token isn't set.");
        }
        OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)(this.endpoint + KEYSERVER_PATH)).setGrantType(GrantType.REFRESH_TOKEN).setClientId(this.accountId).setClientSecret("blabla").setRefreshToken(this.refreshToken).buildQueryMessage();
        request.addHeader("X-Forwarded-For", AskFastRestClient.getOrigin());
        OAuthJSONAccessTokenResponse response = null;
        try {
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            response = oAuthClient.accessToken(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("- AccessToken Requested - " + AskFastRestClient.getOrigin() + " " + this.accountId + " " + (response != null && response.getAccessToken() != null));
        if (response.getAccessToken() != null) {
            this.accessToken = response.getAccessToken();
        }
        return this.accessToken;
    }

    public static void setOrigin(String host) {
        request_host.set(host);
    }

    private static String getOrigin() {
        if (request_host.get() != null) {
            return request_host.get();
        }
        return Thread.currentThread().getStackTrace()[4].getClassName();
    }
}

