/*
 * Decompiled with CFR 0.152.
 */
package com.askfast.askfastapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public class MediaProperty {
    private MediumType medium;
    private Map<MediaPropertyKey, String> properties;

    public MediaProperty() {
        this.properties = new HashMap<MediaPropertyKey, String>();
    }

    public MediaProperty(MediumType type, MediaPropertyKey key, String value) {
        this.medium = type;
        this.properties = new HashMap<MediaPropertyKey, String>();
        this.properties.put(key, value);
    }

    public MediumType getMedium() {
        return this.medium;
    }

    public void setMedium(MediumType medium) {
        this.medium = medium;
    }

    public Map<MediaPropertyKey, String> getProperties() {
        return this.properties;
    }

    public void addProperty(MediaPropertyKey key, String value) {
        this.properties.put(key, value);
    }

    public static enum TRANSCRIPTION_SERVICES {
        MODEL1_G,
        MODEL2_T;

    }

    public static enum MediumType {
        EMAIL,
        BROADSOFT,
        GTALK,
        SKYPE,
        SMS,
        TWITTER;


        @JsonCreator
        public static MediumType fromJson(String name) {
            return MediumType.valueOf(name.toUpperCase());
        }
    }

    public static enum MediaPropertyKey {
        TIMEOUT,
        ANSWER_INPUT,
        ANSWER_INPUT_MIN_LENGTH,
        ANSWER_INPUT_MAX_LENGTH,
        TYPE,
        VOICE_MESSAGE_LENGTH,
        VOICE_MESSAGE_URL,
        RETRY_LIMIT,
        VOICE_MESSAGE_BEEP,
        DTMF_TERMINATE,
        TSS_SPEED,
        USE_EXTERNAL_CALLERID,
        USE_PRECONNECT,
        CONFERENCE_ROOM_NAME,
        CONFERENCE_START_ON_CONNECT,
        CONFERENCE_END_ON_DISCONNECT,
        CONFERENCE_WAIT_URL,
        CALL_LENGTH,
        CONFERENCE_EXIT_ON_STAR,
        TRANSCRIPT,
        TRANSCRIPT_URL,
        TRANSCRIPT_LANG,
        TRANSCRIPT_SERVICE_TYPE,
        RECORD_FROM_ANSWER_DUAL,
        RECORD_FROM_ANSWER,
        RECORD_FROM_RINGING,
        RECORD_FROM_RINGING_DUAL,
        RECORD_FROM_START,
        MACHINE_DETECTION,
        FINISH_ON_KEY,
        SPEECH_TIMEOUT,
        SPEECH_HINTS;


        @JsonCreator
        public static MediaPropertyKey fromJson(String name) {
            return MediaPropertyKey.valueOf(name.toUpperCase());
        }
    }
}

