/*
 * Decompiled with CFR 0.152.
 */
package com.askfast.askfastapi.model;

import com.askfast.askfastapi.model.Answer;
import com.askfast.askfastapi.model.EventCallback;
import com.askfast.askfastapi.model.EventPost;
import com.askfast.askfastapi.model.MediaProperty;
import com.askfast.model.ModelBase;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Question
extends ModelBase {
    public static final String QUESTION_TYPE_CLOSED = "closed";
    public static final String QUESTION_TYPE_OPEN = "open";
    public static final String QUESTION_TYPE_COMMENT = "comment";
    public static final String QUESTION_TYPE_REFERRAL = "referral";
    public static final String QUESTION_TYPE_VOICE_RECORDING = "audio";
    public static final String QUESTION_TYPE_CONFERENCE = "conference";
    public static final String QUESTION_TYPE_EXIT = "exit";
    public static final String QUESTION_TYPE_REJECT = "reject";
    private Collection<MediaProperty> media_properties;
    private String preferred_language = "nl";
    private String question_id = "";
    private String question_text = null;
    private String type = null;
    private List<String> url = null;
    ArrayList<Answer> answers;
    ArrayList<EventCallback> event_callbacks;

    public Question() {
        this(UUID.randomUUID().toString(), "", "");
    }

    public Question(String id, String text, String type) {
        this.setQuestion_id(id);
        this.setQuestion_text(text);
        this.setType(type);
        this.answers = new ArrayList();
        this.event_callbacks = new ArrayList();
    }

    public void addAnswer(Answer answer) {
        this.answers.add(answer);
    }

    public String getQuestion_id() {
        return this.question_id;
    }

    public String getQuestion_text() {
        return this.question_text;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getUrl() {
        return this.url;
    }

    public ArrayList<Answer> getAnswers() {
        return this.answers;
    }

    public ArrayList<EventCallback> getEvent_callbacks() {
        return this.event_callbacks;
    }

    public void setQuestion_id(String question_id) {
        this.question_id = question_id;
    }

    public void setQuestion_text(String question_text) {
        this.question_text = question_text;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPreferred_language() {
        return this.preferred_language;
    }

    public void setPreferred_language(String preferred_language) {
        this.preferred_language = preferred_language;
    }

    public void setUrl(List<String> url) {
        this.url = url;
    }

    public void setAnswers(ArrayList<Answer> answers) {
        this.answers = answers;
    }

    public void setEvent_callbacks(ArrayList<EventCallback> event_callbacks) {
        this.event_callbacks = event_callbacks;
    }

    public static Question fromJson(String json) {
        return Question.fromJSON(json, Question.class);
    }

    @JsonProperty(value="media_properties")
    public Collection<MediaProperty> getMediaProperties() {
        return this.media_properties;
    }

    @JsonProperty(value="media_properties")
    public void setMediaProperties(Collection<MediaProperty> media_Hints) {
        this.media_properties = media_Hints;
    }

    public void addMediaProperties(MediaProperty mediaProperty) {
        this.media_properties = this.media_properties == null ? new ArrayList() : this.media_properties;
        boolean propertyUpdated = false;
        for (MediaProperty property : this.media_properties) {
            if (!property.getMedium().equals((Object)mediaProperty.getMedium())) continue;
            property.getProperties().putAll(mediaProperty.getProperties());
            propertyUpdated = true;
        }
        if (!propertyUpdated) {
            this.media_properties.add(mediaProperty);
        }
    }

    @JsonIgnore
    public Map<MediaProperty.MediaPropertyKey, String> getMediaPropertyByType(MediaProperty.MediumType type) {
        if (this.media_properties != null) {
            for (MediaProperty mediaProperties : this.media_properties) {
                if (!mediaProperties.getMedium().equals((Object)type)) continue;
                return mediaProperties.getProperties();
            }
        }
        return null;
    }

    public String getMediaPropertyValue(MediaProperty.MediumType type, MediaProperty.MediaPropertyKey key) {
        Map<MediaProperty.MediaPropertyKey, String> properties = this.getMediaPropertyByType(type);
        if (properties != null && properties.containsKey((Object)key)) {
            return properties.get((Object)key);
        }
        return null;
    }

    public void addEvent_callbacks(EventPost.EventType eventType, String callbackURL) {
        this.event_callbacks = this.event_callbacks != null ? this.event_callbacks : new ArrayList();
        this.event_callbacks.add(new EventCallback(eventType, callbackURL));
    }

    public void addEventCallback(EventCallback eventCallback) {
        this.event_callbacks = this.event_callbacks != null ? this.event_callbacks : new ArrayList();
        this.event_callbacks.add(eventCallback);
    }

    public void addProperty(MediaProperty.MediumType medium, MediaProperty.MediaPropertyKey propertyKey, String value) {
        MediaProperty mediaProperty = new MediaProperty();
        mediaProperty.setMedium(medium);
        mediaProperty.addProperty(propertyKey, value);
        this.addMediaProperties(mediaProperty);
    }
}

