/*
 * Decompiled with CFR 0.152.
 */
package com.askfast.askfastapi.util;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

public class HttpUtil {
    private OkHttpClient client = new OkHttpClient();
    private Response response = null;

    public static String get(String url) throws IOException {
        return HttpUtil.get(url, null);
    }

    public static String get(String url, Map<String, String> headers) throws IOException {
        HttpUtil httpUtil = new HttpUtil();
        Request request = httpUtil.getBuilderWIthHeaders(url, headers).build();
        httpUtil.response = httpUtil.client.newCall(request).execute();
        return httpUtil.response.body().string();
    }

    public static String post(String url, String body, Map<String, String> headers) throws IOException {
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)body);
        HttpUtil httpUtil = new HttpUtil();
        Request request = httpUtil.getBuilderWIthHeaders(url, headers).post(requestBody).build();
        httpUtil.response = httpUtil.client.newCall(request).execute();
        return httpUtil.response.body().string();
    }

    public static String post(String url, String body) throws IOException {
        return HttpUtil.post(url, body, null);
    }

    public static String postForm(String url, Map<String, String> params) throws IOException {
        return HttpUtil.postForm(url, params, null);
    }

    public static String postForm(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        String body = "";
        if (params != null) {
            boolean first = true;
            for (String param : params.keySet()) {
                if (first) {
                    first = false;
                } else {
                    body = body + "&";
                }
                String value = params.get(param);
                body = body + URLEncoder.encode(param, "UTF-8") + "=";
                body = body + URLEncoder.encode(value, "UTF-8");
            }
        }
        return HttpUtil.post(url, body, headers);
    }

    public static String put(String url, String body, Map<String, String> headers) throws IOException {
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)body);
        HttpUtil httpUtil = new HttpUtil();
        Request request = httpUtil.getBuilderWIthHeaders(url, null).put(requestBody).build();
        httpUtil.response = httpUtil.client.newCall(request).execute();
        return httpUtil.response.body().string();
    }

    public static String put(String url, String body) throws IOException {
        return HttpUtil.put(url, body, null);
    }

    public static String delete(String url, Map<String, String> headers) throws IOException {
        HttpUtil httpUtil = new HttpUtil();
        Request request = httpUtil.getBuilderWIthHeaders(url, null).delete().build();
        httpUtil.response = httpUtil.client.newCall(request).execute();
        return httpUtil.response.body().string();
    }

    public static String delete(String url) throws IOException {
        return HttpUtil.delete(url, null);
    }

    public static String appendQueryParams(String url, Map<String, String> params) throws IOException {
        if (params != null) {
            for (String param : params.keySet()) {
                try {
                    url = url.replace(" ", "%20");
                    URIBuilder uriBuilder = new URIBuilder(new URI(url));
                    URIBuilder returnResult = new URIBuilder(new URI(url)).removeQuery();
                    String queryValue = params.get(param);
                    queryValue = queryValue.replace("+", URLEncoder.encode("+", "UTF-8"));
                    String decodedQueryParam = URLDecoder.decode(queryValue, "UTF-8");
                    if (!decodedQueryParam.equals(queryValue)) {
                        queryValue = decodedQueryParam;
                    }
                    returnResult.addParameter(param, queryValue);
                    for (NameValuePair nameValue : uriBuilder.getQueryParams()) {
                        if (nameValue.getName().equals(queryValue)) continue;
                        returnResult.addParameter(nameValue.getName(), nameValue.getValue());
                    }
                    url = returnResult.toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return url;
    }

    public static Map<String, String> getQueryParams(String url) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            url = url.replace(" ", "%20");
            URIBuilder uriBuilder = new URIBuilder(new URI(url));
            for (NameValuePair nameValue : uriBuilder.getQueryParams()) {
                params.put(nameValue.getName(), nameValue.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    public static String removeQueryParams(String url) throws IOException {
        try {
            url = url.replace(" ", "%20");
            URIBuilder uriBuilder = new URIBuilder(new URI(url));
            return uriBuilder.removeQuery().toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String fetch(String method, String url, String body, Map<String, String> headers) throws IOException {
        String response = null;
        if ("GET".equalsIgnoreCase(method)) {
            response = HttpUtil.get(url, headers);
        } else if ("POST".equalsIgnoreCase(method)) {
            response = HttpUtil.post(url, body, headers);
        } else if ("PUT".equalsIgnoreCase(method)) {
            response = HttpUtil.put(url, body, headers);
        } else if ("DELETE".equalsIgnoreCase(method)) {
            response = HttpUtil.delete(url, headers);
        } else if ("POST-FORM".equalsIgnoreCase(method)) {
            response = HttpUtil.postForm(url, HttpUtil.getQueryParams(url), headers);
        }
        return response;
    }

    private Request.Builder getBuilderWIthHeaders(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder().url(url);
        if (headers != null) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        return builder;
    }

    public static String streamToString(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

