/*
 * Decompiled with CFR 0.152.
 */
package com.assemblade.client;

import com.assemblade.client.AbstractClient;
import com.assemblade.client.CallFailedException;
import com.assemblade.client.ClientException;
import com.assemblade.client.model.Authentication;
import com.assemblade.client.model.AuthenticationPolicy;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.codehaus.jackson.type.TypeReference;

public class Policies
extends AbstractClient {
    public Policies(Authentication authentication) {
        super(authentication);
    }

    public List<AuthenticationPolicy> getAuthenticationPolicies() throws ClientException {
        return this.get("/policies", new TypeReference<List<AuthenticationPolicy>>(){});
    }

    public AuthenticationPolicy addAuthenticationPolicy(AuthenticationPolicy policy) throws ClientException {
        return this.add("/policies", policy, new TypeReference<AuthenticationPolicy>(){});
    }

    public AuthenticationPolicy updateAuthenticationPolicy(AuthenticationPolicy policy) throws ClientException {
        try {
            return this.add("/policies/name/" + URIUtil.encode((String)policy.getName(), (BitSet)URI.allowed_fragment), policy, new TypeReference<AuthenticationPolicy>(){});
        }
        catch (URIException e) {
            throw new CallFailedException("Failed to encode request path", e);
        }
    }

    public void deleteAuthenticationPolicy(AuthenticationPolicy policy) throws ClientException {
        try {
            this.delete("/policies/name/" + URIUtil.encode((String)policy.getName(), (BitSet)URI.allowed_fragment));
        }
        catch (URIException e) {
            throw new CallFailedException("Failed to encode request path", e);
        }
    }
}

