/*
 * Decompiled with CFR 0.152.
 */
package com.assemblade.client;

import com.assemblade.client.CallFailedException;
import com.assemblade.client.ClientException;
import com.assemblade.client.InvalidStatusException;
import com.assemblade.client.model.Authentication;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.scribe.services.HMACSha1SignatureService;
import org.scribe.services.SignatureService;
import org.scribe.services.TimestampService;
import org.scribe.services.TimestampServiceImpl;
import org.scribe.utils.OAuthEncoder;

public abstract class AbstractClient {
    protected final ObjectMapper mapper = new ObjectMapper();
    protected final HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    protected final String baseUrl;
    protected final TimestampService timestampService = new TimestampServiceImpl();
    protected final SignatureService signatureService = new HMACSha1SignatureService();
    protected final Authentication authentication;

    public AbstractClient(String baseUrl) {
        this.baseUrl = baseUrl;
        this.authentication = null;
    }

    public AbstractClient(Authentication authentication) {
        this.baseUrl = authentication.getBaseUrl();
        this.authentication = authentication;
    }

    protected <T> T get(String path, TypeReference<T> type) throws ClientException {
        return this.getFromUrl(this.baseUrl + path, type);
    }

    protected <T> T getFromUrl(String url, TypeReference<T> type) throws ClientException {
        GetMethod get = new GetMethod(url);
        try {
            int statusCode = this.executeMethod((HttpMethodBase)get);
            if (statusCode == 200) {
                Object object;
                try {
                    object = this.mapper.readValue(get.getResponseBodyAsStream(), type);
                }
                catch (IOException e) {
                    throw new CallFailedException("Failed to deserialize a response object", e);
                }
                return (T)object;
            }
            throw new InvalidStatusException(200, statusCode);
        }
        finally {
            get.releaseConnection();
        }
    }

    protected <T> T add(String path, T object, TypeReference<T> type) throws ClientException {
        PostMethod post = new PostMethod(this.baseUrl + path);
        try {
            try {
                post.setRequestEntity((RequestEntity)new StringRequestEntity(this.mapper.writeValueAsString(object), "application/json", null));
            }
            catch (IOException e) {
                throw new CallFailedException("Failed to serialize a request object", e);
            }
            int statusCode = this.executeMethod((HttpMethodBase)post);
            if (statusCode == 200) {
                Object object2;
                try {
                    object2 = this.mapper.readValue(post.getResponseBodyAsStream(), type);
                }
                catch (IOException e) {
                    throw new CallFailedException("Failed to deserialize a response object", e);
                }
                return (T)object2;
            }
            throw new InvalidStatusException(200, statusCode);
        }
        finally {
            post.releaseConnection();
        }
    }

    protected <T> T update(String path, T object, TypeReference<T> type) throws ClientException {
        PutMethod put = new PutMethod(this.baseUrl + path);
        try {
            try {
                put.setRequestEntity((RequestEntity)new StringRequestEntity(this.mapper.writeValueAsString(object), "application/json", null));
            }
            catch (IOException e) {
                throw new CallFailedException("Failed to serialize a request object", e);
            }
            int statusCode = this.executeMethod((HttpMethodBase)put);
            if (statusCode == 200) {
                Object object2;
                try {
                    object2 = this.mapper.readValue(put.getResponseBodyAsStream(), type);
                }
                catch (IOException e) {
                    throw new CallFailedException("Failed to deserialize a response object", e);
                }
                return (T)object2;
            }
            throw new InvalidStatusException(200, statusCode);
        }
        finally {
            put.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(String path) throws ClientException {
        DeleteMethod delete = new DeleteMethod(this.baseUrl + path);
        try {
            int statusCode = this.executeMethod((HttpMethodBase)delete);
            if (statusCode != 204) {
                throw new InvalidStatusException(204, statusCode);
            }
        }
        finally {
            delete.releaseConnection();
        }
    }

    protected int executeMethod(HttpMethodBase method) throws CallFailedException {
        try {
            this.generateSignature(method);
            this.client.executeMethod((HttpMethod)method);
            return method.getStatusCode();
        }
        catch (Exception e) {
            throw new CallFailedException("Method execution failed", e);
        }
    }

    private void generateSignature(HttpMethodBase method) throws URIException {
        if (this.authentication != null) {
            String verb = method.getName();
            String url = OAuthEncoder.encode((String)method.getURI().toString());
            ArrayList<NameValuePair> queryStrings = new ArrayList<NameValuePair>();
            queryStrings.add(new NameValuePair("oauth_consumer_key", this.authentication.getToken()));
            queryStrings.add(new NameValuePair("oauth_nonce", this.timestampService.getNonce()));
            queryStrings.add(new NameValuePair("oauth_signature_method", this.signatureService.getSignatureMethod()));
            queryStrings.add(new NameValuePair("oauth_timestamp", this.timestampService.getTimestampInSeconds()));
            queryStrings.add(new NameValuePair("oauth_version", "1.0"));
            method.setQueryString(queryStrings.toArray(new NameValuePair[0]));
            String queryString = OAuthEncoder.encode((String)method.getQueryString());
            String baseString = verb + "&" + url + "&" + queryString;
            String signature = this.signatureService.getSignature(baseString, this.authentication.getSecret(), "");
            queryStrings.add(new NameValuePair("oauth_signature", signature));
            method.setQueryString(queryStrings.toArray(new NameValuePair[0]));
        }
    }
}

