/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.processor.util;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.util.PrintUtil;

public class RulePrinter {
    public static String print(List<Rule> rules) {
        StringBuilder buff = new StringBuilder();
        for (Rule rule : rules) {
            buff.append(RulePrinter.print(rule));
        }
        return buff.toString();
    }

    public static String print(Rule rule) {
        StringBuilder buff = new StringBuilder();
        buff.append("[ ");
        if (rule.getName() != null) {
            buff.append(rule.getName());
            buff.append(": ");
        }
        if (rule.isBackward()) {
            for (ClauseEntry aHead : rule.getHead()) {
                buff.append(RulePrinter.print(aHead));
                buff.append(" ");
            }
            buff.append("<- ");
            for (ClauseEntry aBody : rule.getBody()) {
                buff.append(RulePrinter.print(aBody));
                buff.append(" ");
            }
        } else {
            for (ClauseEntry aBody : rule.getBody()) {
                buff.append(RulePrinter.print(aBody));
                buff.append(" ");
            }
            buff.append("-> ");
            for (ClauseEntry aHead : rule.getHead()) {
                buff.append(RulePrinter.print(aHead));
                buff.append(" ");
            }
        }
        buff.append("]");
        return buff.toString();
    }

    public static String print(ClauseEntry entry) {
        if (entry instanceof TriplePattern) {
            TriplePattern tp = (TriplePattern)entry;
            StringBuilder buff = new StringBuilder();
            buff.append("(");
            if (tp.getSubject().isURI()) {
                buff.append("<").append(tp.getSubject().getURI()).append(">").toString();
            } else {
                buff.append(PrintUtil.print((Node)tp.getSubject()));
            }
            buff.append(" ");
            if (tp.getPredicate().isURI()) {
                buff.append("<").append(tp.getPredicate().getURI()).append(">").toString();
            } else {
                buff.append(PrintUtil.print((Node)tp.getPredicate()));
            }
            buff.append(" ");
            if (tp.getObject().isURI()) {
                buff.append("<").append(tp.getObject().getURI()).append(">").toString();
            } else {
                buff.append(PrintUtil.print((Node)tp.getObject()));
            }
            buff.append(")");
            return buff.toString();
        }
        return PrintUtil.print((Object)entry);
    }
}

