/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.processor.util;

import com.atomgraph.processor.exception.OntologyException;
import com.atomgraph.processor.vocabulary.LDT;
import com.atomgraph.processor.vocabulary.SIOC;
import com.sun.jersey.api.uri.UriTemplateParser;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.UriBuilder;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontology.AllValuesFromRestriction;
import org.apache.jena.ontology.HasValueRestriction;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Skolemizer {
    private static final Logger log = LoggerFactory.getLogger(Skolemizer.class);
    private final Ontology ontology;
    private final UriBuilder baseUriBuilder;
    private final UriBuilder absolutePathBuilder;

    public Skolemizer(Ontology ontology, UriBuilder baseUriBuilder, UriBuilder absolutePathBuilder) {
        if (ontology == null) {
            throw new IllegalArgumentException("Ontology cannot be null");
        }
        if (baseUriBuilder == null) {
            throw new IllegalArgumentException("UriBuilder cannot be null");
        }
        if (absolutePathBuilder == null) {
            throw new IllegalArgumentException("UriBuilder cannot be null");
        }
        this.ontology = ontology;
        this.baseUriBuilder = baseUriBuilder;
        this.absolutePathBuilder = absolutePathBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model build(Model model) {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        HashMap<Resource, String> resourceURIMap = new HashMap<Resource, String>();
        try (ResIterator resIt = model.listSubjects();){
            while (resIt.hasNext()) {
                URI uri;
                Resource resource = (Resource)resIt.next();
                if (!resource.isAnon() || (uri = this.build(resource)) == null) continue;
                resourceURIMap.put(resource, uri.toString());
            }
        }
        for (Map.Entry entry : resourceURIMap.entrySet()) {
            ResourceUtils.renameResource((Resource)((Resource)entry.getKey()), (String)((String)entry.getValue()));
        }
        return model;
    }

    public URI build(Resource resource) {
        SortedSet<ClassPrecedence> matchedClasses = this.match(this.getOntology(), resource, RDF.type, 0);
        if (!matchedClasses.isEmpty()) {
            OntClass typeClass = matchedClasses.first().getOntClass();
            if (log.isDebugEnabled()) {
                log.debug("Skolemizing resource {} using ontology class {}", (Object)resource, (Object)typeClass);
            }
            return this.build(resource, typeClass);
        }
        return null;
    }

    public URI build(Resource resource, OntClass typeClass) {
        Resource parent;
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (typeClass == null) {
            throw new IllegalArgumentException("OntClass cannot be null");
        }
        String path = this.getStringValue(typeClass, (Property)LDT.path);
        if (path == null) {
            throw new IllegalStateException("Cannot skolemize resource of class " + typeClass + " which does not have ldt:path annotation");
        }
        UriBuilder builder = path.startsWith("/") ? this.getBaseUriBuilder().clone() : ((parent = this.getParent(typeClass)) != null ? UriBuilder.fromUri((String)parent.getURI()) : this.getAbsolutePathBuilder().clone());
        Map<String, String> nameValueMap = this.getNameValueMap(resource, new UriTemplateParser(path));
        builder.path(path);
        String fragment = this.getStringValue(typeClass, (Property)LDT.fragment);
        return builder.fragment(fragment).buildFromMap(nameValueMap);
    }

    protected Map<String, String> getNameValueMap(Resource resource, UriTemplateParser parser) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (parser == null) {
            throw new IllegalArgumentException("UriTemplateParser cannot be null");
        }
        HashMap<String, String> nameValueMap = new HashMap<String, String>();
        List names = parser.getNames();
        for (String name : names) {
            Literal literal = this.getLiteral(resource, name);
            if (literal == null) continue;
            nameValueMap.put(name, literal.getString());
        }
        return nameValueMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Literal getLiteral(Resource resource, String namePath) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (namePath.contains(".")) {
            String name = namePath.substring(0, namePath.indexOf("."));
            String nameSubPath = namePath.substring(namePath.indexOf(".") + 1);
            Resource subResource = this.getResource(resource, name);
            if (subResource != null) {
                return this.getLiteral(subResource, nameSubPath);
            }
        }
        try (StmtIterator it = resource.listProperties();){
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                if (!stmt.getObject().isLiteral() || !stmt.getPredicate().getLocalName().equals(namePath)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Found Literal {} for property name: {} ", (Object)stmt.getLiteral(), (Object)namePath);
                }
                Literal literal = stmt.getLiteral();
                return literal;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource getResource(Resource resource, String name) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        try (StmtIterator it = resource.listProperties();){
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                if (!stmt.getObject().isAnon() || !stmt.getPredicate().getLocalName().equals(name)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Found Resource {} for property name: {} ", (Object)stmt.getResource(), (Object)name);
                }
                Resource resource2 = stmt.getResource();
                return resource2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<ClassPrecedence> match(Ontology ontology, Resource resource, Property property, int level) {
        if (ontology == null) {
            throw new IllegalArgumentException("Ontology cannot be null");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        TreeSet<ClassPrecedence> matchedClasses = new TreeSet<ClassPrecedence>();
        try (ResIterator it = ontology.getOntModel().listResourcesWithProperty((Property)LDT.path);){
            while (it.hasNext()) {
                Resource ontClassRes = (Resource)it.next();
                OntClass ontClass = ontology.getOntModel().getOntResource(ontClassRes).asClass();
                if (ontClass.getIsDefinedBy() == null || !ontClass.getIsDefinedBy().equals((Object)ontology) || !resource.hasProperty(property, (RDFNode)ontClass)) continue;
                ClassPrecedence precedence = new ClassPrecedence(ontClass, level * -1);
                if (log.isTraceEnabled()) {
                    log.trace("Resource {} matched OntClass {}", (Object)resource, (Object)ontClass);
                }
                matchedClasses.add(precedence);
            }
        }
        try (ExtendedIterator imports = ontology.listImports();){
            while (imports.hasNext()) {
                OntResource importRes = (OntResource)imports.next();
                if (!importRes.canAs(Ontology.class)) continue;
                Ontology importedOntology = importRes.asOntology();
                SortedSet<ClassPrecedence> matchedImportClasses = this.match(importedOntology, resource, property, level + 1);
                matchedClasses.addAll(matchedImportClasses);
            }
        }
        return matchedClasses;
    }

    protected String getStringValue(OntClass ontClass, Property property) {
        if (ontClass == null) {
            throw new IllegalArgumentException("OntClass cannot be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        if (ontClass.hasProperty(property)) {
            if (!ontClass.getPropertyValue(property).isLiteral() || ontClass.getPropertyValue(property).asLiteral().getDatatype() == null || !ontClass.getPropertyValue(property).asLiteral().getDatatype().equals(XSDDatatype.XSDstring)) {
                if (log.isErrorEnabled()) {
                    log.error("Class {} property {} is not an xsd:string literal", (Object)ontClass, (Object)property);
                }
                throw new OntologyException("Class '" + ontClass + "' property '" + property + "' is not an xsd:string literal");
            }
            return ontClass.getPropertyValue(property).asLiteral().getString();
        }
        return null;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public UriBuilder getBaseUriBuilder() {
        return this.baseUriBuilder;
    }

    public Resource getParent(OntClass ontClass) {
        if (ontClass == null) {
            throw new IllegalArgumentException("OntClass cannot be null");
        }
        try (ExtendedIterator hasValueIt = ontClass.listSuperClasses();){
            while (hasValueIt.hasNext()) {
                HasValueRestriction hvr;
                OntClass superClass = (OntClass)hasValueIt.next();
                if (!superClass.canAs(HasValueRestriction.class) || !(hvr = (HasValueRestriction)superClass.as(HasValueRestriction.class)).getOnProperty().equals(SIOC.HAS_PARENT) && !hvr.getOnProperty().equals(SIOC.HAS_CONTAINER)) continue;
                if (!hvr.getHasValue().isURIResource()) {
                    if (log.isErrorEnabled()) {
                        log.error("HasValue restriction on class {} for property {} is not a URI resource", (Object)ontClass, (Object)hvr.getOnProperty());
                    }
                    throw new OntologyException("HasValue restriction on class '" + ontClass + "' for property '" + hvr.getOnProperty() + "' is not a URI resource");
                }
                Resource resource = hvr.getHasValue().asResource();
                return resource;
            }
        }
        try (ExtendedIterator allValuesFromIt = ontClass.listSuperClasses();){
            while (allValuesFromIt.hasNext()) {
                OntClass superClass = (OntClass)allValuesFromIt.next();
                if (!superClass.canAs(AllValuesFromRestriction.class)) continue;
                AllValuesFromRestriction avr = (AllValuesFromRestriction)superClass.as(AllValuesFromRestriction.class);
                if (!avr.getAllValuesFrom().canAs(OntClass.class)) {
                    if (log.isErrorEnabled()) {
                        log.error("AllValuesFrom restriction on class {} for property {} is not an OntClass resource", (Object)ontClass, (Object)avr.getOnProperty());
                    }
                    throw new OntologyException("AllValuesFrom restriction on class '" + ontClass + "' for property '" + avr.getOnProperty() + "' is not an OntClass resource");
                }
                OntClass valueClass = (OntClass)avr.getAllValuesFrom().as(OntClass.class);
                Resource resource = this.getParent(valueClass);
                return resource;
            }
        }
        return null;
    }

    public UriBuilder getAbsolutePathBuilder() {
        return this.absolutePathBuilder;
    }

    public static class ClassPrecedence
    implements Comparable {
        private final OntClass ontClass;
        private final int precedence;

        public ClassPrecedence(OntClass ontClass, int precedence) {
            if (ontClass == null) {
                throw new IllegalArgumentException("OntClass cannot be null");
            }
            this.ontClass = ontClass;
            this.precedence = precedence;
        }

        public final OntClass getOntClass() {
            return this.ontClass;
        }

        public final int getPrecedence() {
            return this.precedence;
        }

        public String toString() {
            return "[<" + this.getOntClass().getURI() + ">, " + this.getPrecedence() + "]";
        }

        public int compareTo(Object obj) {
            ClassPrecedence template = (ClassPrecedence)obj;
            return template.getPrecedence() - this.getPrecedence();
        }
    }
}

