/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.processor.util;

import com.atomgraph.processor.exception.OntologyException;
import com.atomgraph.processor.model.Template;
import com.atomgraph.processor.vocabulary.LDT;
import com.sun.jersey.api.uri.UriTemplate;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateMatcher {
    private static final Logger log = LoggerFactory.getLogger(TemplateMatcher.class);
    private final Ontology ontology;

    public TemplateMatcher(Ontology ontology) {
        this.ontology = ontology;
    }

    public Template match(URI uri, URI base) {
        if (uri == null) {
            throw new IllegalArgumentException("URI being matched cannot be null");
        }
        if (base == null) {
            throw new IllegalArgumentException("Base URI cannot be null");
        }
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI being matched \"" + uri + "\" is not absolute");
        }
        if (base.relativize(uri).equals(uri)) {
            throw new IllegalArgumentException("URI being matched \"" + uri + "\" is not relative to the base URI \"" + base + "\"");
        }
        StringBuilder path = new StringBuilder();
        path.append("/").append(base.relativize(uri));
        return this.match(this.getOntology(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TemplatePrecedence> match(Ontology ontology, CharSequence path, int level) {
        if (ontology == null) {
            throw new IllegalArgumentException("Ontology cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("CharSequence cannot be null");
        }
        if (log.isTraceEnabled()) {
            log.trace("Matching path '{}' against resource templates in sitemap: {}", (Object)path, (Object)ontology);
        }
        if (log.isTraceEnabled()) {
            log.trace("Ontology import level: {}", (Object)level);
        }
        ArrayList<TemplatePrecedence> matches = new ArrayList<TemplatePrecedence>();
        try (ResIterator it = ontology.getOntModel().listResourcesWithProperty(RDF.type, (RDFNode)LDT.Template);){
            while (it.hasNext()) {
                HashMap map;
                Template template = (Template)((Resource)it.next()).as(Template.class);
                if (template.getIsDefinedBy() == null || !template.getIsDefinedBy().equals((Object)ontology)) continue;
                if (template.getMatch() == null) {
                    if (log.isErrorEnabled()) {
                        log.error("Template {} does not have value for {} annotation", (Object)template, (Object)LDT.match);
                    }
                    throw new OntologyException("Template '" + template + "' does not have value for '" + LDT.match + "' annotation");
                }
                UriTemplate match = template.getMatch();
                if (match.match(path, map = new HashMap())) {
                    if (log.isTraceEnabled()) {
                        log.trace("Path {} matched UriTemplate {}", (Object)path, (Object)match);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Path {} matched OntClass {}", (Object)path, (Object)template);
                    }
                    TemplatePrecedence precedence = new TemplatePrecedence(template, level * -1);
                    matches.add(precedence);
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace("Path {} did not match UriTemplate {}", (Object)path, (Object)match);
            }
            ArrayList<Ontology> importedOntologies = new ArrayList<Ontology>();
            try (ExtendedIterator importIt = ontology.listImports();){
                while (importIt.hasNext()) {
                    OntResource importRes = (OntResource)importIt.next();
                    if (!importRes.canAs(Ontology.class)) continue;
                    importedOntologies.add(importRes.asOntology());
                }
            }
            for (Ontology importedOntology : importedOntologies) {
                matches.addAll(this.match(importedOntology, path, level + 1));
            }
        }
        return matches;
    }

    public Template match(Ontology ontology, CharSequence path) {
        if (ontology == null) {
            throw new IllegalArgumentException("Ontology cannot be null");
        }
        List<TemplatePrecedence> precedences = this.match(ontology, path, 0);
        if (!precedences.isEmpty()) {
            ArrayList<Template> topMatches = new ArrayList<Template>();
            Collections.sort(precedences, TemplatePrecedence.COMPARATOR);
            TemplatePrecedence maxPrecedence = precedences.get(0);
            for (TemplatePrecedence precedence : precedences) {
                if (!precedence.equals(maxPrecedence)) continue;
                topMatches.add(precedence.getTemplate());
            }
            if (log.isTraceEnabled()) {
                log.trace("{} path matched these Templates: {} (selecting the first UriTemplate)", (Object)path, precedences);
            }
            Collections.sort(topMatches, Template.COMPARATOR);
            Template match = (Template)topMatches.get(0);
            if (log.isDebugEnabled()) {
                log.debug("Path: {} matched Template: {}", (Object)path, (Object)match);
            }
            for (Template template : topMatches) {
                if (template == match || !template.equals(match) || !log.isWarnEnabled()) continue;
                log.warn("Path: {} has conflicting Template: {} (it is equal to the matched one)", (Object)path, (Object)template);
            }
            return match;
        }
        if (log.isDebugEnabled()) {
            log.debug("Path {} has no Template match in this OntModel", (Object)path);
        }
        return null;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public static class TemplatePrecedence {
        public static final Comparator<TemplatePrecedence> COMPARATOR = new Comparator<TemplatePrecedence>(){

            @Override
            public int compare(TemplatePrecedence template1, TemplatePrecedence template2) {
                return template2.getPrecedence() - template1.getPrecedence();
            }
        };
        private final Template template;
        private final int precedence;

        public TemplatePrecedence(Template template, int precedence) {
            this.template = template;
            this.precedence = precedence;
        }

        public Template getTemplate() {
            return this.template;
        }

        public int getPrecedence() {
            return this.precedence;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + Objects.hashCode(this.getPrecedence());
            hash = 59 * hash + Objects.hashCode(this.getTemplate().getPriority());
            hash = 59 * hash + Objects.hashCode(this.getTemplate().getMatch());
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplatePrecedence other = (TemplatePrecedence)obj;
            return Objects.equals(this.getPrecedence(), other.getPrecedence());
        }

        public String toString() {
            return "[<" + this.getTemplate().getURI() + ">, " + this.getPrecedence() + "]";
        }
    }
}

