/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.processor.util;

import java.util.List;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spinrdf.constraints.ConstraintViolation;
import org.spinrdf.constraints.SPINConstraints;
import org.spinrdf.system.SPINModuleRegistry;

public class Validator {
    private static final Logger log = LoggerFactory.getLogger(Validator.class);
    private final OntModel ontModel;

    public Validator(OntModel ontModel) {
        if (ontModel == null) {
            throw new IllegalArgumentException("OntModel cannot be null");
        }
        this.ontModel = ontModel;
        SPINModuleRegistry.get().registerAll((Model)ontModel, null);
    }

    public List<ConstraintViolation> validate(Model model) {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM;
        OntModel tempModel = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
        tempModel.add((Model)this.fixOntModel(this.getOntModel())).add(model);
        return SPINConstraints.check((Model)tempModel, null);
    }

    public OntModel fixOntModel(OntModel ontModel) {
        if (ontModel == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        OntModel fixedModel = ModelFactory.createOntologyModel((OntModelSpec)ontModel.getSpecification());
        Query fix = QueryFactory.create((String)"CONSTRUCT\n{\n  ?s ?p ?o\n}\nWHERE\n{\n  ?s ?p ?o\n  FILTER (!(?p = <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> && ?o = <https://www.w3.org/ns/ldt#Constraint>))\n}");
        try (QueryExecution qex = QueryExecutionFactory.create((Query)fix, (Model)ontModel);){
            fixedModel.add(qex.execConstruct());
        }
        return fixedModel;
    }

    public OntModel getOntModel() {
        return this.ontModel;
    }
}

