/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.io;

import com.atomgraph.core.io.ModelProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.shared.NoReaderForLangException;
import org.apache.jena.shared.NoWriterForLangException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasedModelProvider
extends ModelProvider {
    private static final Logger log = LoggerFactory.getLogger(BasedModelProvider.class);
    @Context
    UriInfo uriInfo;

    public Model readFrom(Class<Model> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Reading Model with HTTP headers: {} MediaType: {}", httpHeaders, (Object)mediaType);
        }
        Model model = ModelFactory.createDefaultModel();
        MediaType formatType = new MediaType(mediaType.getType(), mediaType.getSubtype());
        Lang lang = RDFLanguages.contentTypeToLang((String)formatType.toString());
        if (lang == null) {
            if (log.isErrorEnabled()) {
                log.error("MediaType '{}' not supported by Jena", (Object)formatType);
            }
            throw new NoReaderForLangException("MediaType not supported: " + formatType);
        }
        if (log.isDebugEnabled()) {
            log.debug("RDF language used to read Model: {}", (Object)lang);
        }
        return this.read(model, entityStream, lang, this.getUriInfo().getBaseUri().toString());
    }

    public void writeTo(Model model, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        MediaType formatType;
        Lang lang;
        if (log.isTraceEnabled()) {
            log.trace("Writing Model with HTTP headers: {} MediaType: {}", httpHeaders, (Object)mediaType);
        }
        if ((lang = RDFLanguages.contentTypeToLang((String)(formatType = new MediaType(mediaType.getType(), mediaType.getSubtype())).toString())) == null) {
            if (log.isErrorEnabled()) {
                log.error("MediaType '{}' not supported by Jena", (Object)formatType);
            }
            throw new NoWriterForLangException("MediaType not supported: " + formatType);
        }
        if (log.isDebugEnabled()) {
            log.debug("RDF language used to read Model: {}", (Object)lang);
        }
        this.write(model, entityStream, lang, this.getUriInfo().getBaseUri().toString());
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

