/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.io;

import com.atomgraph.processor.util.Validator;
import com.atomgraph.server.exception.ConstraintViolationException;
import com.atomgraph.server.io.BasedModelProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spinrdf.constraints.ConstraintViolation;

public class ValidatingModelProvider
extends BasedModelProvider {
    private static final Logger log = LoggerFactory.getLogger(ValidatingModelProvider.class);
    @Context
    private Providers providers;

    @Override
    public Model readFrom(Class<Model> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return this.process(super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream));
    }

    public Model process(Model model) {
        return this.validate(model);
    }

    public Model validate(Model model) {
        List<ConstraintViolation> cvs = new Validator(this.getOntology().getOntModel()).validate(model);
        if (!cvs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("SPIN constraint violations: {}", cvs);
            }
            throw new ConstraintViolationException(cvs, model);
        }
        return model;
    }

    public Ontology getOntology() {
        ContextResolver cr = this.getProviders().getContextResolver(Ontology.class, null);
        return (Ontology)cr.getContext(Ontology.class);
    }

    public Providers getProviders() {
        return this.providers;
    }
}

