/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.mapper;

import com.atomgraph.server.exception.ConstraintViolationException;
import com.atomgraph.server.mapper.ExceptionMapperBase;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spinrdf.constraints.SPINConstraints;
import org.spinrdf.vocabulary.SPIN;

public class ConstraintViolationExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<ConstraintViolationException> {
    private static final Logger log = LoggerFactory.getLogger(ConstraintViolationExceptionMapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response toResponse(ConstraintViolationException ex) {
        Resource exception = this.toResource(ex, (Response.StatusType)Response.Status.BAD_REQUEST, ResourceFactory.createResource((String)"http://www.w3.org/2011/http-statusCodes#BadRequest"));
        ex.getModel().add(exception.getModel());
        SPINConstraints.addConstraintViolationsRDF(ex.getConstraintViolations(), (Model)ex.getModel(), (boolean)true);
        try (ResIterator it = ex.getModel().listSubjectsWithProperty(RDF.type, (RDFNode)SPIN.ConstraintViolation);){
            while (it.hasNext()) {
                Resource violation = (Resource)it.next();
                ex.getModel().add(exception, ResourceFactory.createProperty((String)"http://www.w3.org/ns/prov#wasDerivedFrom"), (RDFNode)violation);
            }
        }
        return this.getResponseBuilder(DatasetFactory.create((Model)ex.getModel())).status(Response.Status.BAD_REQUEST).build();
    }
}

