/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.model.impl;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.exception.NotFoundException;
import com.atomgraph.core.model.Service;
import com.atomgraph.core.model.impl.QueriedResourceBase;
import com.atomgraph.core.util.Link;
import com.atomgraph.processor.exception.OntologyException;
import com.atomgraph.processor.model.Application;
import com.atomgraph.processor.util.RulePrinter;
import com.atomgraph.processor.util.TemplateCall;
import com.atomgraph.processor.vocabulary.LDT;
import com.atomgraph.server.model.QueriedResource;
import com.atomgraph.server.model.Resource;
import com.sun.jersey.api.core.ResourceContext;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.Path;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.sparql.util.Loader;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spinrdf.arq.ARQ2SPIN;
import org.spinrdf.model.Template;

@Path(value="/")
public class ResourceBase
extends QueriedResourceBase
implements Resource,
QueriedResource {
    private static final Logger log = LoggerFactory.getLogger(ResourceBase.class);
    private final Application application;
    private final Ontology ontology;
    private final TemplateCall templateCall;
    private final OntResource ontResource;
    private final ResourceContext resourceContext;
    private final HttpHeaders httpHeaders;
    private final QuerySolutionMap querySolutionMap;
    private final Query query;
    private final UpdateRequest update;

    public ResourceBase(@Context UriInfo uriInfo, @Context Request request, @Context MediaTypes mediaTypes, @Context Service service, @Context Application application, @Context Ontology ontology, @Context TemplateCall templateCall, @Context HttpHeaders httpHeaders, @Context ResourceContext resourceContext) {
        this(uriInfo, request, mediaTypes, uriInfo.getAbsolutePath(), service, application, ontology, templateCall, httpHeaders, resourceContext);
    }

    protected ResourceBase(UriInfo uriInfo, Request request, MediaTypes mediaTypes, URI uri, Service service, Application application, Ontology ontology, TemplateCall templateCall, HttpHeaders httpHeaders, ResourceContext resourceContext) {
        super(uriInfo, request, mediaTypes, uri, service);
        if (templateCall == null) {
            if (log.isDebugEnabled()) {
                log.debug("Resource {} has not matched any template, returning 404 Not Found", (Object)this.getURI());
            }
            throw new NotFoundException("Resource has not matched any template");
        }
        if (application == null) {
            throw new IllegalArgumentException("Application cannot be null");
        }
        if (ontology == null) {
            throw new IllegalArgumentException("Ontology cannot be null");
        }
        if (httpHeaders == null) {
            throw new IllegalArgumentException("HttpHeaders cannot be null");
        }
        if (resourceContext == null) {
            throw new IllegalArgumentException("ResourceContext cannot be null");
        }
        this.application = application;
        this.ontology = ontology;
        this.ontResource = ontology.getOntModel().createOntResource(this.getURI().toString());
        this.templateCall = templateCall;
        this.httpHeaders = httpHeaders;
        this.resourceContext = resourceContext;
        this.querySolutionMap = templateCall.getQuerySolutionMap();
        this.querySolutionMap.add("this", (RDFNode)this.ontResource);
        if (templateCall.getTemplate().getQuery() == null) {
            if (log.isErrorEnabled()) {
                log.error("ldt:query value for template '{}' is missing", (Object)templateCall.getTemplate());
            }
            throw new OntologyException("ldt:query value for template '" + templateCall.getTemplate() + "' is missing");
        }
        org.apache.jena.rdf.model.Resource queryType = templateCall.getTemplate().getQuery().getPropertyResourceValue(RDF.type);
        if (queryType == null) {
            if (log.isErrorEnabled()) {
                log.error("ldt:query value for template '{}' does not have a type", (Object)templateCall.getTemplate());
            }
            throw new OntologyException("ldt:query value of template '" + templateCall.getTemplate() + "' does not have a type");
        }
        if (queryType.canAs(Template.class)) {
            Template queryTemplate = (Template)queryType.as(Template.class);
            this.query = new ParameterizedSparqlString(ARQ2SPIN.getTextOnly((org.apache.jena.rdf.model.Resource)queryTemplate.getBody()), this.querySolutionMap, uriInfo.getBaseUri().toString()).asQuery();
        } else {
            this.query = new ParameterizedSparqlString(ARQ2SPIN.getTextOnly((org.apache.jena.rdf.model.Resource)templateCall.getTemplate().getQuery()), this.querySolutionMap, uriInfo.getBaseUri().toString()).asQuery();
        }
        if (templateCall.getTemplate().getUpdate() != null) {
            org.apache.jena.rdf.model.Resource updateType = templateCall.getTemplate().getUpdate().getPropertyResourceValue(RDF.type);
            if (updateType == null) {
                if (log.isErrorEnabled()) {
                    log.error("ldt:update value for template '{}' does not have a type", (Object)templateCall.getTemplate());
                }
                throw new OntologyException("ldt:update value for template '" + templateCall.getTemplate() + "' does not have a type");
            }
            if (updateType.canAs(Template.class)) {
                Template updateTemplate = (Template)updateType.as(Template.class);
                this.update = new ParameterizedSparqlString(ARQ2SPIN.getTextOnly((org.apache.jena.rdf.model.Resource)updateTemplate.getBody()), this.querySolutionMap, uriInfo.getBaseUri().toString()).asUpdate();
            } else {
                this.update = new ParameterizedSparqlString(ARQ2SPIN.getTextOnly((org.apache.jena.rdf.model.Resource)templateCall.getTemplate().getUpdate()), this.querySolutionMap, uriInfo.getBaseUri().toString()).asUpdate();
            }
        } else {
            this.update = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Constructing ResourceBase with matched Template: {}", (Object)templateCall.getTemplate());
        }
    }

    @Path(value="{path: .+}")
    public Object getSubResource() {
        if (this.getTemplateCall().getTemplate().getLoadClass() != null) {
            org.apache.jena.rdf.model.Resource javaClass = this.getTemplateCall().getTemplate().getLoadClass();
            if (!javaClass.isURIResource()) {
                if (log.isErrorEnabled()) {
                    log.error("ldt:loadClass value of template '{}' is not a URI resource", (Object)this.getTemplateCall().getTemplate());
                }
                throw new OntologyException("ldt:loadClass value of template '" + this.getTemplateCall().getTemplate() + "' is not a URI resource");
            }
            Class clazz = Loader.loadClass((String)javaClass.getURI());
            if (clazz == null) {
                if (log.isErrorEnabled()) {
                    log.error("Java class with URI '{}' could not be loaded", (Object)javaClass.getURI());
                }
                throw new OntologyException("Java class with URI '" + javaClass.getURI() + "' not found");
            }
            if (log.isDebugEnabled()) {
                log.debug("Loading Java class with URI: {}", (Object)javaClass.getURI());
            }
            return this.getResourceContext().getResource(clazz);
        }
        return this;
    }

    public Response post(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset cannot be null");
        }
        this.getService().getDatasetAccessor().add(dataset.getDefaultModel());
        Iterator it = dataset.listNames();
        while (it.hasNext()) {
            String graphName = (String)it.next();
            this.getService().getDatasetAccessor().add(graphName, dataset.getNamedModel(graphName));
        }
        return Response.ok().build();
    }

    public Response put(Dataset dataset) {
        this.delete();
        return this.post(dataset);
    }

    public Response delete() {
        this.get();
        if (this.getUpdate() == null) {
            return Response.status((int)501).build();
        }
        if (log.isDebugEnabled()) {
            log.debug("DELETE UpdateRequest: {}", (Object)this.getUpdate());
        }
        this.getService().getEndpointAccessor().update(this.getUpdate(), Collections.emptyList(), Collections.emptyList());
        return Response.noContent().build();
    }

    public QuerySolutionMap getQuerySolutionMap() {
        return this.querySolutionMap;
    }

    public Response.ResponseBuilder getResponseBuilder(Dataset dataset) {
        Response.ResponseBuilder rb = super.getResponseBuilder(dataset);
        rb.cacheControl(this.getCacheControl());
        rb.header("Link", (Object)new Link(URI.create(this.getTemplateCall().getTemplate().getURI()), LDT.template.getURI(), null));
        rb.header("Link", (Object)new Link(URI.create(this.getApplication().getOntology().getURI()), LDT.ontology.getURI(), null));
        rb.header("Link", (Object)new Link(this.getUriInfo().getBaseUri(), LDT.base.getURI(), null));
        Reasoner reasoner = this.getTemplateCall().getTemplate().getOntModel().getSpecification().getReasoner();
        if (reasoner instanceof GenericRuleReasoner) {
            GenericRuleReasoner grr = (GenericRuleReasoner)reasoner;
            rb.header("Rules", (Object)RulePrinter.print(grr.getRules()));
        }
        return rb;
    }

    public List<Locale> getLanguages() {
        return this.getTemplateCall().getTemplate().getLanguages();
    }

    public OntResource getOntResource() {
        return this.ontResource;
    }

    @Override
    public TemplateCall getTemplateCall() {
        return this.templateCall;
    }

    public CacheControl getCacheControl() {
        return this.getTemplateCall().getTemplate().getCacheControl();
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public UpdateRequest getUpdate() {
        return this.update;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Ontology getOntology() {
        return this.ontology;
    }
}

