/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.local;

import com.browserstack.local.LocalBinary;
import com.browserstack.local.LocalException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Local {
    List<String> command;
    private Process proc = null;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public Local() {
        this.parameters.put("v", "-vvv");
        this.parameters.put("f", "-f");
        this.parameters.put("force", "-force");
        this.parameters.put("only", "-only");
        this.parameters.put("forcelocal", "-forcelocal");
        this.parameters.put("localIdentifier", "-localIdentifier");
        this.parameters.put("onlyAutomate", "-onlyAutomate");
        this.parameters.put("proxyHost", "-proxyHost");
        this.parameters.put("proxyPort", "-proxyPort");
        this.parameters.put("proxyUser", "-proxyUser");
        this.parameters.put("proxyPass", "-proxyPass");
        this.parameters.put("forceproxy", "-forceproxy");
        this.parameters.put("hosts", "-hosts");
    }

    public void start(Map<String, String> options) throws Exception {
        block7: {
            this.command = new ArrayList<String>();
            if (options.get("binarypath") != null) {
                this.command.add(options.get("binarypath"));
            } else {
                LocalBinary lb = new LocalBinary();
                this.command.add(lb.getBinaryPath());
            }
            String logFilePath = options.get("logfile") == null ? System.getProperty("user.dir") + "/local.log" : options.get("logfile");
            this.command.add("-logFile");
            this.command.add(logFilePath);
            this.command.add(options.get("key"));
            this.makeCommand(options);
            if (options.get("onlyCommand") != null) {
                return;
            }
            if (this.proc == null) {
                String string;
                ProcessBuilder processBuilder = new ProcessBuilder(this.command);
                FileWriter fw = new FileWriter(logFilePath);
                fw.write("");
                fw.close();
                this.proc = processBuilder.start();
                FileReader f = new FileReader(logFilePath);
                BufferedReader reader = new BufferedReader(f);
                while (true) {
                    if ((string = reader.readLine()) == null) {
                        continue;
                    }
                    if (string.equalsIgnoreCase("Press Ctrl-C to exit")) {
                        f.close();
                        break block7;
                    }
                    if (string.contains("*** Error")) break;
                }
                f.close();
                this.stop();
                throw new LocalException(string);
            }
        }
    }

    public void stop() throws InterruptedException {
        if (this.proc != null) {
            this.proc.destroy();
            while (this.isRunning()) {
                Thread.sleep(1000L);
            }
        }
    }

    public boolean isRunning() {
        if (this.proc == null) {
            return false;
        }
        try {
            this.proc.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    private void makeCommand(Map<String, String> options) {
        for (Map.Entry<String, String> opt : options.entrySet()) {
            String parameter;
            List<String> ignoreKeys = Arrays.asList("key", "logfile", "binarypath");
            if (ignoreKeys.contains(parameter = opt.getKey().trim())) continue;
            if (this.parameters.get(parameter) != null) {
                this.command.add(this.parameters.get(parameter));
            } else {
                this.command.add("-" + parameter);
            }
            if (opt.getValue() == null) continue;
            this.command.add(opt.getValue().trim());
        }
    }
}

