/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.VirusFound;

public class WebsiteScanResult {
    public static final String SERIALIZED_NAME_CLEAN_RESULT = "CleanResult";
    @SerializedName(value="CleanResult")
    @Nullable
    private Boolean cleanResult;
    public static final String SERIALIZED_NAME_WEBSITE_THREAT_TYPE = "WebsiteThreatType";
    @SerializedName(value="WebsiteThreatType")
    @Nullable
    private WebsiteThreatTypeEnum websiteThreatType;
    public static final String SERIALIZED_NAME_FOUND_VIRUSES = "FoundViruses";
    @SerializedName(value="FoundViruses")
    @Nullable
    private List<VirusFound> foundViruses = new ArrayList<VirusFound>();
    public static final String SERIALIZED_NAME_WEBSITE_HTTP_RESPONSE_CODE = "WebsiteHttpResponseCode";
    @SerializedName(value="WebsiteHttpResponseCode")
    @Nullable
    private Integer websiteHttpResponseCode;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WebsiteScanResult cleanResult(@Nullable Boolean cleanResult) {
        this.cleanResult = cleanResult;
        return this;
    }

    @Nullable
    public Boolean getCleanResult() {
        return this.cleanResult;
    }

    public void setCleanResult(@Nullable Boolean cleanResult) {
        this.cleanResult = cleanResult;
    }

    public WebsiteScanResult websiteThreatType(@Nullable WebsiteThreatTypeEnum websiteThreatType) {
        this.websiteThreatType = websiteThreatType;
        return this;
    }

    @Nullable
    public WebsiteThreatTypeEnum getWebsiteThreatType() {
        return this.websiteThreatType;
    }

    public void setWebsiteThreatType(@Nullable WebsiteThreatTypeEnum websiteThreatType) {
        this.websiteThreatType = websiteThreatType;
    }

    public WebsiteScanResult foundViruses(@Nullable List<VirusFound> foundViruses) {
        this.foundViruses = foundViruses;
        return this;
    }

    public WebsiteScanResult addFoundVirusesItem(VirusFound foundVirusesItem) {
        if (this.foundViruses == null) {
            this.foundViruses = new ArrayList<VirusFound>();
        }
        this.foundViruses.add(foundVirusesItem);
        return this;
    }

    @Nullable
    public List<VirusFound> getFoundViruses() {
        return this.foundViruses;
    }

    public void setFoundViruses(@Nullable List<VirusFound> foundViruses) {
        this.foundViruses = foundViruses;
    }

    public WebsiteScanResult websiteHttpResponseCode(@Nullable Integer websiteHttpResponseCode) {
        this.websiteHttpResponseCode = websiteHttpResponseCode;
        return this;
    }

    @Nullable
    public Integer getWebsiteHttpResponseCode() {
        return this.websiteHttpResponseCode;
    }

    public void setWebsiteHttpResponseCode(@Nullable Integer websiteHttpResponseCode) {
        this.websiteHttpResponseCode = websiteHttpResponseCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebsiteScanResult websiteScanResult = (WebsiteScanResult)o;
        return Objects.equals(this.cleanResult, websiteScanResult.cleanResult) && Objects.equals((Object)this.websiteThreatType, (Object)websiteScanResult.websiteThreatType) && Objects.equals(this.foundViruses, websiteScanResult.foundViruses) && Objects.equals(this.websiteHttpResponseCode, websiteScanResult.websiteHttpResponseCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cleanResult, this.websiteThreatType, this.foundViruses, this.websiteHttpResponseCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebsiteScanResult {\n");
        sb.append("    cleanResult: ").append(this.toIndentedString(this.cleanResult)).append("\n");
        sb.append("    websiteThreatType: ").append(this.toIndentedString((Object)this.websiteThreatType)).append("\n");
        sb.append("    foundViruses: ").append(this.toIndentedString(this.foundViruses)).append("\n");
        sb.append("    websiteHttpResponseCode: ").append(this.toIndentedString(this.websiteHttpResponseCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayfoundViruses;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in WebsiteScanResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `WebsiteScanResult` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_WEBSITE_THREAT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_WEBSITE_THREAT_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_WEBSITE_THREAT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `WebsiteThreatType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WEBSITE_THREAT_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WEBSITE_THREAT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_WEBSITE_THREAT_TYPE).isJsonNull()) {
            WebsiteThreatTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_WEBSITE_THREAT_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_FOUND_VIRUSES) != null && !jsonObj.get(SERIALIZED_NAME_FOUND_VIRUSES).isJsonNull() && (jsonArrayfoundViruses = jsonObj.getAsJsonArray(SERIALIZED_NAME_FOUND_VIRUSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FOUND_VIRUSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `FoundViruses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FOUND_VIRUSES).toString()));
            }
            for (int i = 0; i < jsonArrayfoundViruses.size(); ++i) {
                VirusFound.validateJsonElement(jsonArrayfoundViruses.get(i));
            }
        }
    }

    public static WebsiteScanResult fromJson(String jsonString) throws IOException {
        return (WebsiteScanResult)JSON.getGson().fromJson(jsonString, WebsiteScanResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLEAN_RESULT);
        openapiFields.add(SERIALIZED_NAME_WEBSITE_THREAT_TYPE);
        openapiFields.add(SERIALIZED_NAME_FOUND_VIRUSES);
        openapiFields.add(SERIALIZED_NAME_WEBSITE_HTTP_RESPONSE_CODE);
        openapiRequiredFields = new HashSet();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WebsiteThreatTypeEnum {
        NONE("None"),
        MALWARE("Malware"),
        PHISHING("Phishing"),
        FORCED_DOWNLOAD("ForcedDownload"),
        UNABLE_TO_CONNECT("UnableToConnect");

        private String value;

        private WebsiteThreatTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WebsiteThreatTypeEnum fromValue(String value) {
            for (WebsiteThreatTypeEnum b : WebsiteThreatTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            WebsiteThreatTypeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<WebsiteThreatTypeEnum> {
            public void write(JsonWriter jsonWriter, WebsiteThreatTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WebsiteThreatTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WebsiteThreatTypeEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!WebsiteScanResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WebsiteScanResult.class));
            return new TypeAdapter<WebsiteScanResult>(){

                public void write(JsonWriter out, WebsiteScanResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public WebsiteScanResult read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    WebsiteScanResult.validateJsonElement(jsonElement);
                    return (WebsiteScanResult)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

