/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.VirusScanAdvancedResult;
import org.openapitools.client.model.VirusScanResult;
import org.openapitools.client.model.WebsiteScanRequest;
import org.openapitools.client.model.WebsiteScanResult;

public class ScanApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ScanApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ScanApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call scanFileCall(File inputFile, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/virus/scan/file";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (inputFile != null) {
            localVarFormParams.put("inputFile", inputFile);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Apikey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call scanFileValidateBeforeCall(File inputFile, ApiCallback _callback) throws ApiException {
        if (inputFile == null) {
            throw new ApiException("Missing the required parameter 'inputFile' when calling scanFile(Async)");
        }
        return this.scanFileCall(inputFile, _callback);
    }

    public VirusScanResult scanFile(File inputFile) throws ApiException {
        ApiResponse<VirusScanResult> localVarResp = this.scanFileWithHttpInfo(inputFile);
        return localVarResp.getData();
    }

    public ApiResponse<VirusScanResult> scanFileWithHttpInfo(File inputFile) throws ApiException {
        Call localVarCall = this.scanFileValidateBeforeCall(inputFile, null);
        Type localVarReturnType = new TypeToken<VirusScanResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call scanFileAsync(File inputFile, ApiCallback<VirusScanResult> _callback) throws ApiException {
        Call localVarCall = this.scanFileValidateBeforeCall(inputFile, _callback);
        Type localVarReturnType = new TypeToken<VirusScanResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call scanFileAdvancedCall(File inputFile, String fileName, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/virus/scan/file/advanced";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (inputFile != null) {
            localVarFormParams.put("inputFile", inputFile);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (fileName != null) {
            localVarHeaderParams.put("fileName", this.localVarApiClient.parameterToString(fileName));
        }
        if (allowExecutables != null) {
            localVarHeaderParams.put("allowExecutables", this.localVarApiClient.parameterToString(allowExecutables));
        }
        if (allowInvalidFiles != null) {
            localVarHeaderParams.put("allowInvalidFiles", this.localVarApiClient.parameterToString(allowInvalidFiles));
        }
        if (allowScripts != null) {
            localVarHeaderParams.put("allowScripts", this.localVarApiClient.parameterToString(allowScripts));
        }
        if (allowPasswordProtectedFiles != null) {
            localVarHeaderParams.put("allowPasswordProtectedFiles", this.localVarApiClient.parameterToString(allowPasswordProtectedFiles));
        }
        if (allowMacros != null) {
            localVarHeaderParams.put("allowMacros", this.localVarApiClient.parameterToString(allowMacros));
        }
        if (allowXmlExternalEntities != null) {
            localVarHeaderParams.put("allowXmlExternalEntities", this.localVarApiClient.parameterToString(allowXmlExternalEntities));
        }
        if (allowInsecureDeserialization != null) {
            localVarHeaderParams.put("allowInsecureDeserialization", this.localVarApiClient.parameterToString(allowInsecureDeserialization));
        }
        if (allowHtml != null) {
            localVarHeaderParams.put("allowHtml", this.localVarApiClient.parameterToString(allowHtml));
        }
        if (allowUnsafeArchives != null) {
            localVarHeaderParams.put("allowUnsafeArchives", this.localVarApiClient.parameterToString(allowUnsafeArchives));
        }
        if (allowOleEmbeddedObject != null) {
            localVarHeaderParams.put("allowOleEmbeddedObject", this.localVarApiClient.parameterToString(allowOleEmbeddedObject));
        }
        if (allowUnwantedAction != null) {
            localVarHeaderParams.put("allowUnwantedAction", this.localVarApiClient.parameterToString(allowUnwantedAction));
        }
        if (options != null) {
            localVarHeaderParams.put("options", this.localVarApiClient.parameterToString(options));
        }
        if (restrictFileTypes != null) {
            localVarHeaderParams.put("restrictFileTypes", this.localVarApiClient.parameterToString(restrictFileTypes));
        }
        String[] localVarAuthNames = new String[]{"Apikey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call scanFileAdvancedValidateBeforeCall(File inputFile, String fileName, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes, ApiCallback _callback) throws ApiException {
        if (inputFile == null) {
            throw new ApiException("Missing the required parameter 'inputFile' when calling scanFileAdvanced(Async)");
        }
        return this.scanFileAdvancedCall(inputFile, fileName, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes, _callback);
    }

    public VirusScanAdvancedResult scanFileAdvanced(File inputFile, String fileName, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        ApiResponse<VirusScanAdvancedResult> localVarResp = this.scanFileAdvancedWithHttpInfo(inputFile, fileName, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes);
        return localVarResp.getData();
    }

    public ApiResponse<VirusScanAdvancedResult> scanFileAdvancedWithHttpInfo(File inputFile, String fileName, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        Call localVarCall = this.scanFileAdvancedValidateBeforeCall(inputFile, fileName, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes, null);
        Type localVarReturnType = new TypeToken<VirusScanAdvancedResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call scanFileAdvancedAsync(File inputFile, String fileName, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes, ApiCallback<VirusScanAdvancedResult> _callback) throws ApiException {
        Call localVarCall = this.scanFileAdvancedValidateBeforeCall(inputFile, fileName, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes, _callback);
        Type localVarReturnType = new TypeToken<VirusScanAdvancedResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call scanWebsiteCall(WebsiteScanRequest input, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WebsiteScanRequest localVarPostBody = input;
        String localVarPath = "/virus/scan/website";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Apikey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call scanWebsiteValidateBeforeCall(WebsiteScanRequest input, ApiCallback _callback) throws ApiException {
        if (input == null) {
            throw new ApiException("Missing the required parameter 'input' when calling scanWebsite(Async)");
        }
        return this.scanWebsiteCall(input, _callback);
    }

    public WebsiteScanResult scanWebsite(WebsiteScanRequest input) throws ApiException {
        ApiResponse<WebsiteScanResult> localVarResp = this.scanWebsiteWithHttpInfo(input);
        return localVarResp.getData();
    }

    public ApiResponse<WebsiteScanResult> scanWebsiteWithHttpInfo(WebsiteScanRequest input) throws ApiException {
        Call localVarCall = this.scanWebsiteValidateBeforeCall(input, null);
        Type localVarReturnType = new TypeToken<WebsiteScanResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call scanWebsiteAsync(WebsiteScanRequest input, ApiCallback<WebsiteScanResult> _callback) throws ApiException {
        Call localVarCall = this.scanWebsiteValidateBeforeCall(input, _callback);
        Type localVarReturnType = new TypeToken<WebsiteScanResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

