/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.time.Duration;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.model.VirusScanAdvancedResult;
import org.openapitools.client.model.VirusScanResult;
import org.openapitools.client.model.WebsiteScanRequest;
import org.openapitools.client.model.WebsiteScanResult;

public class ScanApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public ScanApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ScanApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public VirusScanResult scanFile(File inputFile) throws ApiException {
        ApiResponse<VirusScanResult> localVarResponse = this.scanFileWithHttpInfo(inputFile);
        return localVarResponse.getData();
    }

    public ApiResponse<VirusScanResult> scanFileWithHttpInfo(File inputFile) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanFileRequestBuilder(inputFile);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanFile", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (VirusScanResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VirusScanResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanFileRequestBuilder(File inputFile) throws ApiException {
        HttpRequest.BodyPublisher formDataPublisher;
        if (inputFile == null) {
            throw new ApiException(400, "Missing the required parameter 'inputFile' when calling scanFile");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/file";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
        boolean hasFiles = false;
        multiPartBuilder.addBinaryBody("inputFile", inputFile);
        hasFiles = true;
        HttpEntity entity = multiPartBuilder.build();
        if (ApiClient.isChunkedTransferEnabled()) {
            Pipe pipe;
            try {
                pipe = Pipe.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            new Thread(() -> {
                try (OutputStream outputStream = Channels.newOutputStream(pipe.sink());){
                    entity.writeTo(outputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).start();
            formDataPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> Channels.newInputStream(pipe.source()));
        } else {
            ByteArrayOutputStream formOutputStream = new ByteArrayOutputStream();
            try {
                entity.writeTo((OutputStream)formOutputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            formDataPublisher = HttpRequest.BodyPublishers.ofByteArray(formOutputStream.toByteArray());
        }
        localVarRequestBuilder.header("Content-Type", entity.getContentType().getValue()).method("POST", formDataPublisher);
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public VirusScanAdvancedResult scanFileAdvanced(File inputFile, String fileName, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        ApiResponse<VirusScanAdvancedResult> localVarResponse = this.scanFileAdvancedWithHttpInfo(inputFile, fileName, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes);
        return localVarResponse.getData();
    }

    public ApiResponse<VirusScanAdvancedResult> scanFileAdvancedWithHttpInfo(File inputFile, String fileName, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanFileAdvancedRequestBuilder(inputFile, fileName, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanFileAdvanced", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (VirusScanAdvancedResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VirusScanAdvancedResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanFileAdvancedRequestBuilder(File inputFile, String fileName, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        HttpRequest.BodyPublisher formDataPublisher;
        if (inputFile == null) {
            throw new ApiException(400, "Missing the required parameter 'inputFile' when calling scanFileAdvanced");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/file/advanced";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (fileName != null) {
            localVarRequestBuilder.header("fileName", fileName.toString());
        }
        if (allowExecutables != null) {
            localVarRequestBuilder.header("allowExecutables", allowExecutables.toString());
        }
        if (allowInvalidFiles != null) {
            localVarRequestBuilder.header("allowInvalidFiles", allowInvalidFiles.toString());
        }
        if (allowScripts != null) {
            localVarRequestBuilder.header("allowScripts", allowScripts.toString());
        }
        if (allowPasswordProtectedFiles != null) {
            localVarRequestBuilder.header("allowPasswordProtectedFiles", allowPasswordProtectedFiles.toString());
        }
        if (allowMacros != null) {
            localVarRequestBuilder.header("allowMacros", allowMacros.toString());
        }
        if (allowXmlExternalEntities != null) {
            localVarRequestBuilder.header("allowXmlExternalEntities", allowXmlExternalEntities.toString());
        }
        if (allowInsecureDeserialization != null) {
            localVarRequestBuilder.header("allowInsecureDeserialization", allowInsecureDeserialization.toString());
        }
        if (allowHtml != null) {
            localVarRequestBuilder.header("allowHtml", allowHtml.toString());
        }
        if (allowUnsafeArchives != null) {
            localVarRequestBuilder.header("allowUnsafeArchives", allowUnsafeArchives.toString());
        }
        if (allowOleEmbeddedObject != null) {
            localVarRequestBuilder.header("allowOleEmbeddedObject", allowOleEmbeddedObject.toString());
        }
        if (allowUnwantedAction != null) {
            localVarRequestBuilder.header("allowUnwantedAction", allowUnwantedAction.toString());
        }
        if (options != null) {
            localVarRequestBuilder.header("options", options.toString());
        }
        if (restrictFileTypes != null) {
            localVarRequestBuilder.header("restrictFileTypes", restrictFileTypes.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
        boolean hasFiles = false;
        multiPartBuilder.addBinaryBody("inputFile", inputFile);
        hasFiles = true;
        HttpEntity entity = multiPartBuilder.build();
        if (ApiClient.isChunkedTransferEnabled()) {
            Pipe pipe;
            try {
                pipe = Pipe.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            new Thread(() -> {
                try (OutputStream outputStream = Channels.newOutputStream(pipe.sink());){
                    entity.writeTo(outputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).start();
            formDataPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> Channels.newInputStream(pipe.source()));
        } else {
            ByteArrayOutputStream formOutputStream = new ByteArrayOutputStream();
            try {
                entity.writeTo((OutputStream)formOutputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            formDataPublisher = HttpRequest.BodyPublishers.ofByteArray(formOutputStream.toByteArray());
        }
        localVarRequestBuilder.header("Content-Type", entity.getContentType().getValue()).method("POST", formDataPublisher);
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public WebsiteScanResult scanWebsite(WebsiteScanRequest input) throws ApiException {
        ApiResponse<WebsiteScanResult> localVarResponse = this.scanWebsiteWithHttpInfo(input);
        return localVarResponse.getData();
    }

    public ApiResponse<WebsiteScanResult> scanWebsiteWithHttpInfo(WebsiteScanRequest input) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanWebsiteRequestBuilder(input);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanWebsite", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (WebsiteScanResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<WebsiteScanResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanWebsiteRequestBuilder(WebsiteScanRequest input) throws ApiException {
        if (input == null) {
            throw new ApiException(400, "Missing the required parameter 'input' when calling scanWebsite");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/website";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)input);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

