/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.VirusFound;

@JsonPropertyOrder(value={"CleanResult", "WebsiteThreatType", "FoundViruses", "WebsiteHttpResponseCode"})
public class WebsiteScanResult {
    public static final String JSON_PROPERTY_CLEAN_RESULT = "CleanResult";
    @Nullable
    private Boolean cleanResult;
    public static final String JSON_PROPERTY_WEBSITE_THREAT_TYPE = "WebsiteThreatType";
    @Nullable
    private WebsiteThreatTypeEnum websiteThreatType;
    public static final String JSON_PROPERTY_FOUND_VIRUSES = "FoundViruses";
    @Nullable
    private List<VirusFound> foundViruses = new ArrayList<VirusFound>();
    public static final String JSON_PROPERTY_WEBSITE_HTTP_RESPONSE_CODE = "WebsiteHttpResponseCode";
    @Nullable
    private Integer websiteHttpResponseCode;

    public WebsiteScanResult cleanResult(@Nullable Boolean cleanResult) {
        this.cleanResult = cleanResult;
        return this;
    }

    @Nullable
    @JsonProperty(value="CleanResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCleanResult() {
        return this.cleanResult;
    }

    @JsonProperty(value="CleanResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCleanResult(@Nullable Boolean cleanResult) {
        this.cleanResult = cleanResult;
    }

    public WebsiteScanResult websiteThreatType(@Nullable WebsiteThreatTypeEnum websiteThreatType) {
        this.websiteThreatType = websiteThreatType;
        return this;
    }

    @Nullable
    @JsonProperty(value="WebsiteThreatType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WebsiteThreatTypeEnum getWebsiteThreatType() {
        return this.websiteThreatType;
    }

    @JsonProperty(value="WebsiteThreatType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebsiteThreatType(@Nullable WebsiteThreatTypeEnum websiteThreatType) {
        this.websiteThreatType = websiteThreatType;
    }

    public WebsiteScanResult foundViruses(@Nullable List<VirusFound> foundViruses) {
        this.foundViruses = foundViruses;
        return this;
    }

    public WebsiteScanResult addFoundVirusesItem(VirusFound foundVirusesItem) {
        if (this.foundViruses == null) {
            this.foundViruses = new ArrayList<VirusFound>();
        }
        this.foundViruses.add(foundVirusesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="FoundViruses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VirusFound> getFoundViruses() {
        return this.foundViruses;
    }

    @JsonProperty(value="FoundViruses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFoundViruses(@Nullable List<VirusFound> foundViruses) {
        this.foundViruses = foundViruses;
    }

    public WebsiteScanResult websiteHttpResponseCode(@Nullable Integer websiteHttpResponseCode) {
        this.websiteHttpResponseCode = websiteHttpResponseCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="WebsiteHttpResponseCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWebsiteHttpResponseCode() {
        return this.websiteHttpResponseCode;
    }

    @JsonProperty(value="WebsiteHttpResponseCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebsiteHttpResponseCode(@Nullable Integer websiteHttpResponseCode) {
        this.websiteHttpResponseCode = websiteHttpResponseCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebsiteScanResult websiteScanResult = (WebsiteScanResult)o;
        return Objects.equals(this.cleanResult, websiteScanResult.cleanResult) && Objects.equals((Object)this.websiteThreatType, (Object)websiteScanResult.websiteThreatType) && Objects.equals(this.foundViruses, websiteScanResult.foundViruses) && Objects.equals(this.websiteHttpResponseCode, websiteScanResult.websiteHttpResponseCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cleanResult, this.websiteThreatType, this.foundViruses, this.websiteHttpResponseCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebsiteScanResult {\n");
        sb.append("    cleanResult: ").append(this.toIndentedString(this.cleanResult)).append("\n");
        sb.append("    websiteThreatType: ").append(this.toIndentedString((Object)this.websiteThreatType)).append("\n");
        sb.append("    foundViruses: ").append(this.toIndentedString(this.foundViruses)).append("\n");
        sb.append("    websiteHttpResponseCode: ").append(this.toIndentedString(this.websiteHttpResponseCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCleanResult() != null) {
            joiner.add(String.format("%sCleanResult%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getCleanResult()))));
        }
        if (this.getWebsiteThreatType() != null) {
            joiner.add(String.format("%sWebsiteThreatType%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString((Object)this.getWebsiteThreatType()))));
        }
        if (this.getFoundViruses() != null) {
            for (int i = 0; i < this.getFoundViruses().size(); ++i) {
                if (this.getFoundViruses().get(i) == null) continue;
                joiner.add(this.getFoundViruses().get(i).toUrlQueryString(String.format("%sFoundViruses%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getWebsiteHttpResponseCode() != null) {
            joiner.add(String.format("%sWebsiteHttpResponseCode%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getWebsiteHttpResponseCode()))));
        }
        return joiner.toString();
    }

    public static enum WebsiteThreatTypeEnum {
        NONE(String.valueOf("None")),
        MALWARE(String.valueOf("Malware")),
        PHISHING(String.valueOf("Phishing")),
        FORCED_DOWNLOAD(String.valueOf("ForcedDownload")),
        UNABLE_TO_CONNECT(String.valueOf("UnableToConnect"));

        private String value;

        private WebsiteThreatTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WebsiteThreatTypeEnum fromValue(String value) {
            for (WebsiteThreatTypeEnum b : WebsiteThreatTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

