/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex;

import com.cml.idex.packets.CancelOrder;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.PlaceOrder;
import com.cml.idex.packets.Req;
import com.cml.idex.packets.Return24Volume;
import com.cml.idex.packets.ReturnBalances;
import com.cml.idex.packets.ReturnCompleteBalances;
import com.cml.idex.packets.ReturnContractAddress;
import com.cml.idex.packets.ReturnCurrencies;
import com.cml.idex.packets.ReturnDepositsWithdrawals;
import com.cml.idex.packets.ReturnNextNonce;
import com.cml.idex.packets.ReturnOpenOrders;
import com.cml.idex.packets.ReturnOrderBook;
import com.cml.idex.packets.ReturnOrderStatus;
import com.cml.idex.packets.ReturnOrderTrades;
import com.cml.idex.packets.ReturnTicker;
import com.cml.idex.packets.ReturnTradeHistory;
import com.cml.idex.packets.Withdraw;
import com.cml.idex.sig.CancelSigParms;
import com.cml.idex.sig.OrderSigParms;
import com.cml.idex.sig.WithdrawSigParms;
import com.cml.idex.util.IdexCrypto;
import com.cml.idex.util.Utils;
import com.cml.idex.value.BalanceOrder;
import com.cml.idex.value.Currency;
import com.cml.idex.value.DepositsWithdrawals;
import com.cml.idex.value.Order;
import com.cml.idex.value.OrderBook;
import com.cml.idex.value.OrderTrade;
import com.cml.idex.value.Outcome;
import com.cml.idex.value.Ticker;
import com.cml.idex.value.TradeHistory;
import com.cml.idex.value.Volume;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.util.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.Sign;

public class IDexAPI {
    private static final Logger log = LoggerFactory.getLogger(IDexAPI.class);
    private static final String HTTP_ENDPOINT = "https://api.idex.market/";
    private static final String CONTENT_TYPE = "application/json";
    private final AsyncHttpClient client = Dsl.asyncHttpClient();
    private final ObjectMapper mapper = new ObjectMapper();
    public static final String DEFAULT_ETH_ADR = "0x0000000000000000000000000000000000000000";

    public CompletableFuture<Order> order(String tokenBuy, BigInteger amountBuy, String tokenSell, BigInteger amountSell, String address, long nonce, long expires, byte v, byte[] r, byte[] s) {
        return this.process(PlaceOrder.create(tokenBuy, amountBuy, tokenSell, amountSell, address, nonce, expires, v, r, s));
    }

    public CompletableFuture<Order> order(Credentials credentials, String contractAdress, long nonce, String tokenBuy, BigInteger amountBuy, String tokenSell, BigInteger amountSell, Long expires) {
        Sign.SignatureData sigData;
        try {
            sigData = IdexCrypto.createParamsSig(new OrderSigParms(contractAdress, tokenBuy, amountBuy, tokenSell, amountSell, expires, nonce, credentials.getAddress()), credentials);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.order(tokenBuy, amountBuy, tokenSell, amountSell, credentials.getAddress(), nonce, expires, sigData.getV(), sigData.getR(), sigData.getS());
    }

    public CompletableFuture<Order> order(Credentials credentials, String tokenBuy, BigInteger amountBuy, String tokenSell, BigInteger amountSell, Long expires) {
        CompletableFuture<Long> nounceF = this.returnNextNonce(credentials.getAddress());
        CompletableFuture<String> ctcAdrF = this.returnContractAddress();
        return CompletableFuture.allOf(ctcAdrF, nounceF).thenCompose(v -> {
            try {
                return this.order(credentials, (String)ctcAdrF.get(), (Long)nounceF.get(), tokenBuy, amountBuy, tokenSell, amountSell, expires);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public CompletableFuture<Outcome> cancel(String orderHash, String address, long nonce, byte v, byte[] r, byte[] s) {
        return this.process(CancelOrder.create(orderHash, address, nonce, v, r, s));
    }

    public CompletableFuture<Outcome> cancel(Credentials credentials, String orderHash) {
        if (log.isDebugEnabled()) {
            log.debug("cancel: orderHash : " + orderHash);
        }
        return this.returnNextNonce(credentials.getAddress()).thenCompose(nonce -> {
            Sign.SignatureData sigData;
            try {
                sigData = IdexCrypto.createParamsSig(new CancelSigParms(orderHash, (Long)nonce), credentials);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.cancel(orderHash, credentials.getAddress(), (long)nonce, sigData.getV(), sigData.getR(), sigData.getS());
        });
    }

    public CompletableFuture<Outcome> withdraw(String address, BigInteger amount, String token, long nonce, byte v, byte[] r, byte[] s) {
        return this.process(Withdraw.create(address, amount, token, nonce, v, r, s));
    }

    public CompletableFuture<Outcome> withdraw(Credentials credentials, String contractAddress, BigInteger amount, String token, long nonce) {
        Sign.SignatureData sigData;
        try {
            sigData = IdexCrypto.createParamsSig(new WithdrawSigParms(contractAddress, token, amount, credentials.getAddress(), nonce), credentials);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.withdraw(credentials.getAddress(), amount, token, nonce, sigData.getV(), sigData.getR(), sigData.getS());
    }

    public CompletableFuture<Outcome> withdraw(Credentials credentials, BigInteger amount, String token) {
        CompletableFuture<Long> nounceF = this.returnNextNonce(credentials.getAddress());
        CompletableFuture<String> ctcAdrF = this.returnContractAddress();
        return CompletableFuture.allOf(ctcAdrF, nounceF).thenCompose(v -> {
            try {
                return this.withdraw(credentials, (String)ctcAdrF.get(), amount, token, (Long)nounceF.get());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public CompletableFuture<Long> returnNextNonce(String address) {
        return this.process(ReturnNextNonce.create(address));
    }

    public CompletableFuture<String> returnContractAddress() {
        return this.process(ReturnContractAddress.create());
    }

    public CompletableFuture<OrderBook> returnOrderBook(String market, Integer count) {
        return this.process(ReturnOrderBook.create(market, count));
    }

    public CompletableFuture<List<Order>> returnOpenOrders(String market, String address, Integer count, Long cursor) {
        return this.process(ReturnOpenOrders.create(market, address, count, cursor));
    }

    public CompletableFuture<Order> returnOrderStatus(String orderHash) {
        return this.process(ReturnOrderStatus.create(orderHash));
    }

    public CompletableFuture<List<OrderTrade>> returnOrderTrades(String orderHash) {
        return this.process(ReturnOrderTrades.create(orderHash));
    }

    public CompletableFuture<List<TradeHistory>> returnTradeHistory(String market, String address, Long start, Long end, String sort, Integer count, Long cursor) {
        return this.process(ReturnTradeHistory.create(market, address, start, end, sort, count, cursor));
    }

    public CompletableFuture<List<TradeHistory>> returnTradeHistory(String market, String address, LocalDateTime start, LocalDateTime end, String sort, Integer count, Long cursor) {
        return this.process(ReturnTradeHistory.create(market, address, Utils.toEpochSecond(start), Utils.toEpochSecond(end), sort, count, cursor));
    }

    public CompletableFuture<DepositsWithdrawals> returnDepositsWithdrawals(String address, LocalDateTime start, LocalDateTime end) {
        return this.process(ReturnDepositsWithdrawals.create(address, start, end));
    }

    public CompletableFuture<Map<String, BalanceOrder>> returnCompleteBalances(String address) {
        return this.process(ReturnCompleteBalances.create(address));
    }

    public CompletableFuture<Map<String, BigDecimal>> returnBalances(String address) {
        return this.process(ReturnBalances.create(address));
    }

    public CompletableFuture<Volume> return24Volume() {
        return this.process(Return24Volume.create());
    }

    public CompletableFuture<Map<String, Currency>> returnCurrencies() {
        return this.process(ReturnCurrencies.create());
    }

    public CompletableFuture<Ticker> returnTicker(String market) {
        return this.process(ReturnTicker.create(market));
    }

    private <V, T extends Parser<V> & Req> CompletableFuture<V> process(T requestParser) {
        return ((CompletableFuture)this.sendAsync(requestParser).thenApply(httpRsp -> httpRsp.getResponseBody())).thenApply(body -> requestParser.parse(this.mapper, (String)body));
    }

    private CompletableFuture<Response> sendAsync(Req req) {
        Request httpreq = ((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder(HttpConstants.Methods.POST).setUrl(HTTP_ENDPOINT + req.getEndpoint())).setHeader((CharSequence)"Content-Type", CONTENT_TYPE)).setBody(req.getPayload())).build();
        return this.client.executeRequest(httpreq).toCompletableFuture();
    }
}

