/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.util.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReturnBalances
implements Req,
Parser<Map<String, BigDecimal>> {
    private final String address;

    private ReturnBalances(String address) {
        this.address = address;
    }

    @Override
    public String getEndpoint() {
        return "returnBalances";
    }

    @Override
    public String getPayload() {
        return "{\"address\": \"" + this.address + "\"}";
    }

    @Override
    public Map<String, BigDecimal> parse(ObjectMapper mapper, String body) {
        if (Utils.isEmptyJson(body)) {
            throw new IDexException(ErrorCode.UNKNOWN_ADDRESS, this.address);
        }
        return ReturnBalances.fromJson(mapper, body);
    }

    public static ReturnBalances create(String address) {
        String fixedAdr = Utils.fixString(address);
        if (fixedAdr == null) {
            throw new IllegalArgumentException("address is required!");
        }
        return new ReturnBalances(address);
    }

    private static Map<String, BigDecimal> fromJson(ObjectMapper mapper, String body) {
        try {
            JsonNode root = mapper.readTree(body);
            Utils.checkError(root);
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            Iterator fieldItr = root.fields();
            while (fieldItr.hasNext()) {
                Map.Entry node = (Map.Entry)fieldItr.next();
                map.put((String)node.getKey(), Utils.toBD(((JsonNode)node.getValue()).asText()));
            }
            return map;
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }
}

