/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.util.Utils;
import com.cml.idex.value.BalanceOrder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReturnCompleteBalances
implements Req,
Parser<Map<String, BalanceOrder>> {
    private final String address;

    private ReturnCompleteBalances(String address) {
        this.address = address;
    }

    @Override
    public String getEndpoint() {
        return "returnCompleteBalances";
    }

    @Override
    public String getPayload() {
        return "{\"address\":\"" + this.address + "\"}";
    }

    @Override
    public Map<String, BalanceOrder> parse(ObjectMapper mapper, String body) {
        if (Utils.isEmptyJson(body)) {
            throw new IDexException(ErrorCode.UNKNOWN_ADDRESS, this.address);
        }
        return ReturnCompleteBalances.fromJson(mapper, body);
    }

    public static ReturnCompleteBalances create(String address) {
        return new ReturnCompleteBalances(address);
    }

    private static Map<String, BalanceOrder> fromJson(ObjectMapper mapper, String body) {
        try {
            JsonNode root = mapper.readTree(body);
            Utils.checkError(root);
            HashMap<String, BalanceOrder> map = new HashMap<String, BalanceOrder>();
            Iterator fieldItr = root.fields();
            while (fieldItr.hasNext()) {
                Map.Entry node = (Map.Entry)fieldItr.next();
                map.put((String)node.getKey(), ReturnCompleteBalances.parseCompleteBalance((JsonNode)node.getValue()));
            }
            return map;
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }

    private static BalanceOrder parseCompleteBalance(JsonNode node) {
        BigDecimal available = Utils.toBDrequired(node, "available");
        BigDecimal onOrders = Utils.toBDrequired(node, "onOrders");
        return new BalanceOrder(available, onOrders);
    }
}

