/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.util.Utils;
import com.cml.idex.value.DepositHistory;
import com.cml.idex.value.DepositsWithdrawals;
import com.cml.idex.value.WithdrawHistory;
import com.cml.idex.value.WithdrawStatus;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ReturnDepositsWithdrawals
implements Req,
Parser<DepositsWithdrawals> {
    private final String address;
    private final Long start;
    private final Long end;

    private ReturnDepositsWithdrawals(String address, LocalDateTime start, LocalDateTime end) {
        this.address = address;
        this.start = start == null ? null : Utils.toEpochSecond(start);
        this.end = end == null ? null : Utils.toEpochSecond(end);
    }

    @Override
    public String getEndpoint() {
        return "returnDepositsWithdrawals";
    }

    @Override
    public String getPayload() {
        StringBuilder sb = new StringBuilder("{\"address\":\"" + this.address + "\"");
        if (this.start != null) {
            sb.append(",\"start\":").append(this.start);
        }
        if (this.end != null) {
            sb.append(",\"end\":").append(this.end);
        }
        return sb.append("}").toString();
    }

    @Override
    public DepositsWithdrawals parse(ObjectMapper mapper, String json) {
        if (Utils.isEmptyJson(json)) {
            throw new IDexException(ErrorCode.UNKNOWN_ADDRESS, this.address);
        }
        return ReturnDepositsWithdrawals.fromJson(mapper, json);
    }

    public static ReturnDepositsWithdrawals create(String address, LocalDateTime start, LocalDateTime end) {
        String adrFixed = Utils.fixString(address);
        if (adrFixed == null) {
            throw new IllegalArgumentException("address is required");
        }
        return new ReturnDepositsWithdrawals(adrFixed, start, end);
    }

    private static DepositsWithdrawals fromJson(ObjectMapper mapper, String body) {
        try {
            JsonNode root = mapper.readTree(body);
            Utils.checkError(root);
            List<DepositHistory> deposits = ReturnDepositsWithdrawals.parseDeposits(root.get("deposits"));
            List<WithdrawHistory> withdrawals = ReturnDepositsWithdrawals.parseWithdrawals(root.get("withdrawals"));
            return new DepositsWithdrawals(deposits, withdrawals);
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }

    private static List<WithdrawHistory> parseWithdrawals(JsonNode node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayNode withdrawArr = (ArrayNode)node;
        Iterator elementItr = withdrawArr.elements();
        LinkedList<WithdrawHistory> deposits = new LinkedList<WithdrawHistory>();
        while (elementItr.hasNext()) {
            JsonNode depNode = (JsonNode)elementItr.next();
            int withdrawalNumber = depNode.get("withdrawalNumber").asInt();
            String currency = depNode.get("currency").asText();
            BigDecimal amount = Utils.toBDrequired(depNode, "amount");
            long timestamp = depNode.get("timestamp").asLong();
            String transactionHash = depNode.get("transactionHash").asText();
            WithdrawStatus status = WithdrawStatus.fromString(depNode.get("status").asText());
            deposits.add(new WithdrawHistory(withdrawalNumber, currency, amount, timestamp, transactionHash, status));
        }
        return deposits;
    }

    private static List<DepositHistory> parseDeposits(JsonNode node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayNode depArr = (ArrayNode)node;
        Iterator elementItr = depArr.elements();
        LinkedList<DepositHistory> deposits = new LinkedList<DepositHistory>();
        while (elementItr.hasNext()) {
            JsonNode depNode = (JsonNode)elementItr.next();
            int depositNumber = depNode.get("depositNumber").asInt();
            String currency = depNode.get("currency").asText();
            BigDecimal amount = Utils.toBDrequired(depNode, "amount");
            long timestamp = depNode.get("timestamp").asLong();
            String transactionHash = depNode.get("transactionHash").asText();
            deposits.add(new DepositHistory(depositNumber, currency, amount, timestamp, transactionHash));
        }
        return deposits;
    }
}

