/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.util.Utils;
import com.cml.idex.value.Currency;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReturnCurrencies
implements Req,
Parser<Map<String, Currency>> {
    public static ReturnCurrencies INSTANCE = new ReturnCurrencies();

    private ReturnCurrencies() {
    }

    @Override
    public String getEndpoint() {
        return "returnCurrencies";
    }

    @Override
    public String getPayload() {
        return "";
    }

    public static ReturnCurrencies create() {
        return INSTANCE;
    }

    @Override
    public Map<String, Currency> parse(ObjectMapper mapper, String body) {
        return ReturnCurrencies.fromJson(mapper, body);
    }

    public static Map<String, Currency> fromJson(ObjectMapper mapper, String body) {
        try {
            JsonNode root = mapper.readTree(body);
            Utils.checkError(root);
            return ReturnCurrencies.parseCurrencies(root);
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }

    public static Map<String, Currency> parseCurrencies(JsonNode node) {
        HashMap<String, Currency> map = new HashMap<String, Currency>();
        Iterator fieldItr = node.fields();
        while (fieldItr.hasNext()) {
            Map.Entry entry = (Map.Entry)fieldItr.next();
            JsonNode nodeEntry = (JsonNode)entry.getValue();
            map.put((String)entry.getKey(), ReturnCurrencies.parseCurrency(nodeEntry));
        }
        return map;
    }

    public static Currency parseCurrency(JsonNode node) {
        if (node == null) {
            return null;
        }
        return new Currency(node.get("decimals").asInt(), node.get("address").asText(), node.get("name").asText());
    }
}

