/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.util.Utils;
import com.cml.idex.value.Currency;
import com.cml.idex.value.CurrencyPairs;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ReturnCurrenciesWithPairs
implements Req,
Parser<CurrencyPairs> {
    public static final ReturnCurrenciesWithPairs INSTANCE = new ReturnCurrenciesWithPairs();

    private ReturnCurrenciesWithPairs() {
    }

    @Override
    public String getEndpoint() {
        return "returnCurrenciesWithPairs";
    }

    @Override
    public String getPayload() {
        return "";
    }

    public static ReturnCurrenciesWithPairs create() {
        return INSTANCE;
    }

    @Override
    public CurrencyPairs parse(ObjectMapper mapper, String json) {
        return ReturnCurrenciesWithPairs.fromJson(mapper, json);
    }

    public static CurrencyPairs fromJson(ObjectMapper mapper, String body) {
        try {
            JsonNode root = mapper.readTree(body);
            Utils.checkError(root);
            HashMap<String, List<String>> pairs = new HashMap<String, List<String>>();
            JsonNode node = root.get("pairs");
            if (node != null) {
                Iterator pairItr = node.fields();
                while (pairItr.hasNext()) {
                    Map.Entry pairNode = (Map.Entry)pairItr.next();
                    LinkedList tokens = new LinkedList();
                    ((JsonNode)pairNode.getValue()).elements().forEachRemaining(tokenNode -> tokens.add(tokenNode.asText()));
                    pairs.put((String)pairNode.getKey(), tokens);
                }
            }
            return new CurrencyPairs(pairs, ReturnCurrenciesWithPairs.parseCurrencies(root.get("tokens")));
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }

    public static Map<String, Currency> parseCurrencies(JsonNode tokensNode) {
        if (tokensNode == null) {
            return null;
        }
        HashMap<String, Currency> currencies = new HashMap<String, Currency>();
        for (JsonNode node : tokensNode) {
            currencies.put(node.get("symbol").asText(), new Currency(node.get("decimals").asInt(), node.get("address").asText(), node.get("name").asText()));
        }
        return currencies;
    }
}

