/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.util.Utils;
import com.cml.idex.value.Order;
import com.cml.idex.value.OrderParm;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ReturnOpenOrders
implements Req,
Parser<List<Order>> {
    final String market;
    final String address;
    final Integer count;
    final String cursor;

    private ReturnOpenOrders(String market, String address, Integer count, String cursor) {
        this.market = market;
        this.address = address;
        this.count = count;
        this.cursor = cursor;
    }

    @Override
    public String getEndpoint() {
        return "returnOpenOrders";
    }

    @Override
    public String getPayload() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.market != null) {
            sb.append("\"market\":\"").append(this.market).append("\"");
        }
        if (this.address != null) {
            if (this.market != null) {
                sb.append(",");
            }
            sb.append("\"address\":\"").append(this.address).append("\"");
        }
        if (this.count != null) {
            sb.append(",\"count\":").append(this.count);
        }
        if (this.cursor != null) {
            sb.append("\"cursor\": \"").append(this.cursor).append("\"");
        }
        return sb.append("}").toString();
    }

    @Override
    public List<Order> parse(ObjectMapper mapper, String json) {
        if (Utils.isEmptyJson(json)) {
            return Collections.emptyList();
        }
        return ReturnOpenOrders.fromJson(mapper, json);
    }

    public static ReturnOpenOrders create(String market, String address, Integer count, String cursor) {
        String marketFixed = Utils.fixString(market);
        String adrFixed = Utils.fixString(address);
        if (marketFixed == null && adrFixed == null) {
            throw new IllegalArgumentException("market or address is requried!");
        }
        if (count != null && (count < 1 || count > 100)) {
            throw new IllegalArgumentException("count must be between 1 and 100 OR null value");
        }
        return new ReturnOpenOrders(marketFixed, adrFixed, count, cursor);
    }

    private static List<Order> fromJson(ObjectMapper mapper, String json) {
        try {
            JsonNode root = mapper.readTree(json);
            LinkedList<Order> orders = new LinkedList<Order>();
            Iterator eleItr = root.elements();
            while (eleItr.hasNext()) {
                orders.add(ReturnOpenOrders.parseOrder((JsonNode)eleItr.next()));
            }
            return orders;
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }

    public static Order parseOrder(JsonNode node) {
        if (node == null) {
            return null;
        }
        JsonNode field = node.get("timestamp");
        Long timestamp = field == null ? null : Long.valueOf(field.asLong());
        field = node.get("market");
        String market = field == null ? null : field.asText();
        field = node.get("orderNumber");
        Long orderNumber = field == null ? null : Long.valueOf(field.asLong());
        String orderHash = node.get("orderHash").asText();
        BigDecimal price = Utils.toBDrequired(node, "price");
        BigDecimal amount = Utils.toBDrequired(node, "amount");
        BigDecimal total = Utils.toBDrequired(node, "total");
        field = node.get("type");
        String type = field == null ? null : field.asText();
        OrderParm params = ReturnOpenOrders.parseOrderParams(node.get("params"));
        return new Order(timestamp, market, orderNumber, orderHash, price, amount, total, type, params);
    }

    private static OrderParm parseOrderParams(JsonNode node) {
        if (node == null) {
            return null;
        }
        String tokenBuy = node.get("tokenBuy").asText();
        int buyPrecision = node.get("buyPrecision").asInt();
        long amountBuy = node.get("amountBuy").asLong();
        String tokenSell = node.get("tokenSell").asText();
        int sellPrecision = node.get("sellPrecision").asInt();
        long amountSell = node.get("amountSell").asLong();
        JsonNode field = node.get("expires");
        Long expires = field == null ? null : Long.valueOf(field.asLong());
        long nonce = node.get("nonce").asLong();
        String user = node.get("user").asText();
        return new OrderParm(tokenBuy, buyPrecision, amountBuy, tokenSell, sellPrecision, amountSell, expires, nonce, user);
    }
}

