/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.packets.ReturnOpenOrders;
import com.cml.idex.util.Utils;
import com.cml.idex.value.Order;
import com.cml.idex.value.OrderBook;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class ReturnOrderBook
implements Req,
Parser<OrderBook> {
    final String market;
    final Integer count;

    private ReturnOrderBook(String market, Integer count) {
        this.market = market;
        this.count = count;
    }

    @Override
    public String getEndpoint() {
        return "returnOrderBook";
    }

    @Override
    public String getPayload() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"market\":\"").append(this.market).append("\"");
        if (this.count != null) {
            sb.append(",\"count\":").append(this.count);
        }
        return sb.append("}").toString();
    }

    @Override
    public OrderBook parse(ObjectMapper mapper, String json) {
        if (Utils.isEmptyJson(json)) {
            return new OrderBook(Collections.emptyList(), Collections.emptyList());
        }
        return ReturnOrderBook.fromJson(mapper, json);
    }

    public static ReturnOrderBook create(String market, Integer count) {
        String marketFixed = Utils.fixString(market);
        if (marketFixed == null) {
            throw new IllegalArgumentException("market is requried!");
        }
        if (count != null && (count < 1 || count > 100)) {
            throw new IllegalArgumentException("count must be between 1 and 100 OR null value");
        }
        return new ReturnOrderBook(marketFixed, count);
    }

    public static OrderBook fromJson(ObjectMapper mapper, String body) {
        try {
            Iterator eleItr;
            JsonNode root = mapper.readTree(body);
            Utils.checkError(root);
            LinkedList<Order> bids = new LinkedList<Order>();
            LinkedList<Order> asks = new LinkedList<Order>();
            JsonNode node = root.get("bids");
            if (node != null) {
                eleItr = node.elements();
                while (eleItr.hasNext()) {
                    bids.add(ReturnOpenOrders.parseOrder((JsonNode)eleItr.next()));
                }
            }
            if ((node = root.get("asks")) != null) {
                eleItr = node.elements();
                while (eleItr.hasNext()) {
                    asks.add(ReturnOpenOrders.parseOrder((JsonNode)eleItr.next()));
                }
            }
            return new OrderBook(bids, asks);
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }
}

