/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.util.Utils;
import com.cml.idex.value.OrderTrade;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ReturnOrderTrades
implements Req,
Parser<List<OrderTrade>> {
    private final String orderHash;

    private ReturnOrderTrades(String orderHash) {
        this.orderHash = orderHash;
    }

    @Override
    public String getEndpoint() {
        return "returnOrderTrades";
    }

    @Override
    public String getPayload() {
        return "{\"orderHash\": \"" + this.orderHash + "\"}";
    }

    @Override
    public List<OrderTrade> parse(ObjectMapper mapper, String json) {
        if (Utils.isEmptyJson(json)) {
            return Collections.emptyList();
        }
        return ReturnOrderTrades.fromJson(mapper, json);
    }

    public static ReturnOrderTrades create(String orderHash) {
        String orderHashFixed = Utils.fixString(orderHash);
        if (orderHashFixed == null) {
            throw new IllegalArgumentException("orderHash is requried!");
        }
        return new ReturnOrderTrades(orderHashFixed);
    }

    private static List<OrderTrade> fromJson(ObjectMapper mapper, String body) {
        try {
            JsonNode root = mapper.readTree(body);
            Utils.checkError(root);
            LinkedList<OrderTrade> orderTrades = new LinkedList<OrderTrade>();
            Iterator eleItr = root.elements();
            while (eleItr.hasNext()) {
                OrderTrade orderTrade = ReturnOrderTrades.parseOrderTrade((JsonNode)eleItr.next());
                if (orderTrade == null) continue;
                orderTrades.add(orderTrade);
            }
            return orderTrades;
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }

    public static OrderTrade parseOrderTrade(JsonNode node) {
        if (node == null) {
            return null;
        }
        BigDecimal amount = Utils.toBD("amount");
        String type = node.get("type").asText();
        BigDecimal total = Utils.toBD("total");
        BigDecimal price = Utils.toBD("price");
        String uuid = node.get("uuid").asText();
        String transactionHash = node.get("transactionHash").asText();
        return new OrderTrade(amount, type, total, price, uuid, transactionHash);
    }
}

