/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.sig;

import com.cml.idex.sig.SigParms;
import com.cml.idex.util.IdexCrypto;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.web3j.utils.Numeric;

public class OrderSigParms
implements SigParms {
    final String contractAddress;
    final String tokenBuy;
    final BigInteger amountBuy;
    final String tokenSell;
    final BigInteger amountSell;
    final long expires;
    final long nonce;
    final String address;

    public OrderSigParms(String contractAddress, String tokenBuy, BigInteger amountBuy, String tokenSell, BigInteger amountSell, long expires, long nonce, String address) {
        this.contractAddress = contractAddress;
        this.tokenBuy = tokenBuy;
        this.amountBuy = amountBuy;
        this.tokenSell = tokenSell;
        this.amountSell = amountSell;
        this.expires = expires;
        this.nonce = nonce;
        this.address = address;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getTokenBuy() {
        return this.tokenBuy;
    }

    public BigInteger getAmountBuy() {
        return this.amountBuy;
    }

    public String getTokenSell() {
        return this.tokenSell;
    }

    public BigInteger getAmountSell() {
        return this.amountSell;
    }

    public long getExpires() {
        return this.expires;
    }

    public long getNonce() {
        return this.nonce;
    }

    public String getAddress() {
        return this.address;
    }

    @Override
    public byte[] encode() throws IOException {
        ByteArrayOutputStream ba = new ByteArrayOutputStream(256);
        ba.write(Numeric.hexStringToByteArray((String)this.contractAddress));
        ba.write(Numeric.hexStringToByteArray((String)this.tokenBuy));
        ba.write(IdexCrypto.encodeNumeric(this.amountBuy));
        ba.write(Numeric.hexStringToByteArray((String)this.tokenSell));
        ba.write(IdexCrypto.encodeNumeric(this.amountSell));
        ba.write(IdexCrypto.encodeNumeric(this.expires));
        ba.write(IdexCrypto.encodeNumeric(this.nonce));
        ba.write(Numeric.hexStringToByteArray((String)this.address));
        return ba.toByteArray();
    }
}

