/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.client.rest.client.jdk;

import com.contentgrid.opa.client.rest.client.jdk.RequestLoggerConfiguration;
import java.io.ByteArrayOutputStream;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogger {
    private static final Logger log = LoggerFactory.getLogger(RequestLogger.class);
    private final RequestLoggerConfiguration config;
    private final BiConsumer<String, Object[]> output;

    public RequestLogger(RequestLoggerConfiguration config, BiConsumer<String, Object[]> output) {
        this.config = config;
        this.output = output;
    }

    public void logRequest(HttpRequest request) {
        HttpRequest.BodyPublisher body;
        if (this.config.isLogRequestLineEnabled()) {
            this.output("{} {} HTTP/{}", request.method(), request.uri(), request.version().map(RequestLogger::asString).orElse("?"));
        }
        if (this.config.isLogRequestHeadersEnabled()) {
            this.printHeaders(request.headers());
        }
        if (this.config.isLogRequestBodyEnabled() && request.bodyPublisher().isPresent() && (body = request.bodyPublisher().get()).contentLength() > 0L) {
            RequestLoggerBodySubscriber subscriber = new RequestLoggerBodySubscriber(body);
            body.subscribe(subscriber);
        }
    }

    public void logResponse(HttpResponse<byte[]> response, Throwable exception) {
        if (response != null) {
            if (this.config.isStatusCodeEnabled()) {
                this.output("HTTP/{} {}", RequestLogger.asString(response.version()), response.statusCode());
            }
            if (this.config.isResponseHeadersEnabled()) {
                this.printHeaders(response.headers());
            }
            if (this.config.isLogResponseBodyEnabled() && response.statusCode() != 204) {
                this.output("<{} bytes>{}{}", response.body().length, System.lineSeparator(), new String(response.body(), StandardCharsets.UTF_8));
            }
        }
    }

    private void printHeaders(HttpHeaders headers) {
        headers.map().forEach((name, values) -> this.output("  {}: {}", name, String.join((CharSequence)",", values)));
    }

    private void output(String format, Object ... args) {
        this.output.accept(format, args);
    }

    private static String asString(HttpClient.Version httpVersion) {
        switch (httpVersion) {
            case HTTP_2: {
                return "2";
            }
            case HTTP_1_1: {
                return "1.1";
            }
        }
        return "?";
    }

    private class RequestLoggerBodySubscriber
    implements Flow.Subscriber<ByteBuffer> {
        private final HttpRequest.BodyPublisher body;
        private final ByteArrayOutputStream outputStream;

        public RequestLoggerBodySubscriber(HttpRequest.BodyPublisher body) {
            Objects.requireNonNull(body, "body is required");
            if (body.contentLength() <= 0L) {
                throw new IllegalArgumentException("request body is empty, content-length: " + body.contentLength());
            }
            this.body = body;
            this.outputStream = new ByteArrayOutputStream();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(this.body.contentLength());
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            this.outputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
        }

        @Override
        public void onError(Throwable throwable) {
            log.warn("Logging request body failed:", throwable);
        }

        @Override
        public void onComplete() {
            String content = this.outputStream.toString(StandardCharsets.UTF_8);
            RequestLogger.this.output("<{} bytes>{}{}", this.outputStream.size(), System.lineSeparator(), content);
        }
    }
}

