/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.client.rest.http;

import com.contentgrid.opa.client.rest.http.MediaType;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface HttpRequestHeaders {
    public HttpRequestHeaders add(String var1, String var2);

    public HttpRequestHeaders set(String var1, String ... var2);

    public HttpRequestHeaders remove(String var1);

    public List<String> get(String var1);

    default public Optional<String> getFirst(String headerName) {
        return this.get(headerName).stream().findFirst();
    }

    default public Optional<MediaType> contentType() {
        return this.getFirst("Content-Type").map(str -> {
            if (str.isEmpty()) {
                return null;
            }
            return MediaType.parseMediaType(str);
        }).or(Optional::empty);
    }

    default public HttpRequestHeaders contentType(MediaType contentType) {
        if (contentType != null) {
            this.set("Content-Type", contentType.toString());
        } else {
            this.remove("Content-Type");
        }
        return this;
    }

    default public HttpRequestHeaders accept(MediaType ... acceptableMediaTypes) {
        return this.set("Accept", Stream.of(acceptableMediaTypes).map(MediaType::toString).collect(Collectors.joining(", ")));
    }

    default public HttpRequestHeaders acceptCharset(Charset ... acceptableCharsets) {
        return this.set("Accept-Charset", Stream.of(acceptableCharsets).map(charset -> charset.name().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(", ")));
    }

    public void forEach(BiConsumer<String, List<String>> var1);

    public static final class Headers {
        public static final String LOCATION = "Location";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String ACCEPT = "Accept";
        public static final String ACCEPT_CHARSET = "Accept-Charset";

        private Headers() {
        }
    }
}

