/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.client;

import com.contentgrid.opa.client.api.CompileApi;
import com.contentgrid.opa.client.api.DataApi;
import com.contentgrid.opa.client.api.PolicyApi;
import com.contentgrid.opa.client.api.QueryApi;
import com.contentgrid.opa.client.impl.CompileComponent;
import com.contentgrid.opa.client.impl.DataComponent;
import com.contentgrid.opa.client.impl.PolicyComponent;
import com.contentgrid.opa.client.impl.QueryComponent;
import com.contentgrid.opa.client.rest.OpaHttpClient;
import com.contentgrid.opa.client.rest.RestClientConfiguration;
import com.contentgrid.opa.client.rest.client.jdk.DefaultOpaHttpClient;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpaClient
implements PolicyApi,
QueryApi,
DataApi,
CompileApi {
    private final CompileApi compileComponent;
    private final QueryApi queryComponent;
    private final DataApi dataComponent;
    private final PolicyApi policyComponent;

    OpaClient(PolicyApi policyComponent, QueryApi queryComponent, DataApi dataComponent, CompileApi compileComponent) {
        this.policyComponent = policyComponent;
        this.queryComponent = queryComponent;
        this.dataComponent = dataComponent;
        this.compileComponent = compileComponent;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CompletableFuture<CompileApi.PartialEvalResponse> compile(CompileApi.PartialEvaluationRequest request) {
        return this.compileComponent.compile(request);
    }

    @Override
    public CompletableFuture<PolicyApi.ListPoliciesResponse> listPolicies() {
        return this.policyComponent.listPolicies();
    }

    @Override
    public CompletableFuture<PolicyApi.UpsertPolicyResponse> upsertPolicy(String id, String policy) {
        return this.policyComponent.upsertPolicy(id, policy);
    }

    @Override
    public CompletableFuture<PolicyApi.GetPolicyResponse> getPolicy(String id) {
        return this.policyComponent.getPolicy(id);
    }

    @Override
    public CompletableFuture<PolicyApi.DeletePolicyResponse> deletePolicy(String id) {
        return this.policyComponent.deletePolicy(id);
    }

    @Override
    public <TData> CompletableFuture<DataApi.UpsertDataResult> upsertData(String path, TData data) {
        return this.dataComponent.upsertData(path, data);
    }

    @Override
    public <TData> CompletableFuture<TData> getData(String path, Class<TData> responseType) {
        return this.dataComponent.getData(path, responseType);
    }

    @Override
    public CompletableFuture<QueryApi.QueryResponse> query(String query) {
        return this.queryComponent.query(query);
    }

    public static class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);
        private String url = "http://localhost:8181";
        private OpaHttpClient restClient = new DefaultOpaHttpClient(HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).followRedirects(HttpClient.Redirect.NORMAL).build(), ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build()).registerModule((Module)new JavaTimeModule()));
        private Consumer<RestClientConfiguration.LogSpecification> httpLogSpec = RestClientConfiguration.LogSpecification::verbose;

        public Builder url(String url) {
            Objects.requireNonNull(url);
            this.url = url;
            return this;
        }

        public Builder restClient(OpaHttpClient restClient) {
            Objects.requireNonNull(restClient);
            this.restClient = restClient;
            return this;
        }

        public Builder httpLogging(Consumer<RestClientConfiguration.LogSpecification> httpLogSpec) {
            Objects.requireNonNull(httpLogSpec);
            this.httpLogSpec = httpLogSpec;
            return this;
        }

        public OpaClient build() {
            OpaHttpClient opaHttpClient = this.getOrCreateDefaultHttpClient();
            return new OpaClient(new PolicyComponent(opaHttpClient), new QueryComponent(opaHttpClient), new DataComponent(opaHttpClient), new CompileComponent(opaHttpClient));
        }

        protected OpaHttpClient getOrCreateDefaultHttpClient() {
            OpaHttpClient client = this.restClient;
            client.configure(config -> config.baseUrl(this.url).logging(this.httpLogSpec));
            return client;
        }
    }
}

