/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.client.rest.client.jdk.converter;

import com.contentgrid.opa.client.rest.client.jdk.HttpEntity;
import com.contentgrid.opa.client.rest.client.jdk.converter.HttpBodyConverter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class ConverterProcessor {
    private final Collection<? extends HttpBodyConverter> objectMappers;

    public ConverterProcessor(Collection<? extends HttpBodyConverter> objectMappers) {
        this.objectMappers = Collections.unmodifiableSet(new LinkedHashSet<HttpBodyConverter>(objectMappers));
    }

    public <T> T read(HttpBodyConverter.DeserializationContext context, Class<T> type) {
        if (Void.TYPE.equals(type) || Void.class.equals(type)) {
            return null;
        }
        return this.objectMappers.stream().filter(mapper -> mapper.canRead(context, type)).findFirst().orElseThrow(() -> {
            String msg = String.format("Cannot convert %s into %s", context.getContentType().toString(), type.getName());
            return new UncheckedIOException(new IOException(msg));
        }).read(context, type);
    }

    public HttpEntity write(HttpBodyConverter.SerializationContext context) {
        if (context.isEmpty()) {
            return new HttpEntity(context.getHeaders());
        }
        byte[] buffer = this.objectMappers.stream().filter(mapper -> mapper.canWrite(context)).findFirst().orElseThrow(() -> {
            String msg = String.format("Cannot convert %s into %s", context.getSource().getClass().getName(), context.getContentType());
            return new UncheckedIOException(new IOException(msg));
        }).write(context);
        return new HttpEntity(context.getHeaders(), buffer);
    }
}

