/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.client.impl;

import com.contentgrid.opa.client.api.PolicyApi;
import com.contentgrid.opa.client.rest.OpaHttpClient;
import com.contentgrid.opa.client.rest.http.MediaType;
import java.util.concurrent.CompletableFuture;

public class PolicyComponent
implements PolicyApi {
    private static final String POLICY_ENDPOINT = "/v1/policies/";
    private final OpaHttpClient restClient;

    @Override
    public CompletableFuture<PolicyApi.ListPoliciesResponse> listPolicies() {
        return this.restClient.get(POLICY_ENDPOINT, PolicyApi.ListPoliciesResponse.class);
    }

    @Override
    public CompletableFuture<PolicyApi.UpsertPolicyResponse> upsertPolicy(String id, String policy) {
        return this.restClient.put(POLICY_ENDPOINT + id, headers -> headers.contentType(MediaType.TEXT_PLAIN), policy, PolicyApi.UpsertPolicyResponse.class);
    }

    @Override
    public CompletableFuture<PolicyApi.GetPolicyResponse> getPolicy(String id) {
        return this.restClient.get(POLICY_ENDPOINT + id, PolicyApi.GetPolicyResponse.class);
    }

    @Override
    public CompletableFuture<PolicyApi.DeletePolicyResponse> deletePolicy(String id) {
        return this.restClient.delete(POLICY_ENDPOINT + id, PolicyApi.DeletePolicyResponse.class);
    }

    public PolicyComponent(OpaHttpClient restClient) {
        this.restClient = restClient;
    }
}

