/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.client.rest.client.jdk.converter;

import com.contentgrid.opa.client.rest.client.jdk.converter.HttpBodyConverter;
import com.contentgrid.opa.client.rest.http.MediaType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class StringConverter
implements HttpBodyConverter {
    private static final List<MediaType> MEDIA_TYPES = List.of(MediaType.TEXT_PLAIN, new MediaType("text", "*"));
    private final Charset defaultCharset;

    public StringConverter() {
        this(StandardCharsets.ISO_8859_1);
    }

    public StringConverter(Charset defaultCharset) {
        this.defaultCharset = Objects.requireNonNull(defaultCharset, "defaultCharset cannot be null");
    }

    @Override
    public <T> boolean canRead(HttpBodyConverter.DeserializationContext context, Class<T> type) {
        return type == String.class && this.supportsMediaType(context.getContentType());
    }

    @Override
    public <T> T read(HttpBodyConverter.DeserializationContext context, Class<T> type) {
        Charset charset = context.getContentType() == null ? this.defaultCharset : context.getContentType().getCharset().orElse(this.defaultCharset);
        return type.cast(new String(context.getSource(), charset));
    }

    @Override
    public boolean canWrite(HttpBodyConverter.SerializationContext context) {
        return context.getSource().getClass() == String.class && this.supportsMediaType(context.getContentType());
    }

    @Override
    public byte[] write(HttpBodyConverter.SerializationContext context) {
        Object source = context.getSource();
        if (source == null) {
            return new byte[0];
        }
        Charset charset = context.getContentType() == null ? this.defaultCharset : context.getContentType().getCharset().orElse(this.defaultCharset);
        return source.toString().getBytes(charset);
    }

    @Override
    public Collection<MediaType> getSupportedMediaTypes() {
        return MEDIA_TYPES;
    }
}

