/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestSuite;
import net.jsunit.ConfigurationException;
import net.jsunit.JsUnitServer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.surefire.junit.JUnitTestSet;
import org.apache.maven.surefire.report.FileReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;
import org.codehaus.mojo.javascript.AbstractJavascriptMojo;
import org.codehaus.mojo.javascript.JsUnitTestCase;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.mortbay.util.MultiException;

public class JsUnitMojo
extends AbstractJavascriptMojo {
    private boolean skip;
    private boolean testFailureIgnore;
    private File reportsDirectory;
    private File workDirectory;
    private File testSourceDirectory;
    private String[] browsers;
    private String[] DEFAULT_BROWSERS = new String[]{"firefox"};
    private int port;
    private String[] excludes;
    private String[] includes;
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.html", "**/*.htm", "**/*.js"};
    private String firefoxPath;
    private String iePath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().warn((CharSequence)"tests are skipped.");
            return;
        }
        String[] tests = this.getTestsToRun();
        if (tests == null || tests.length == 0) {
            this.getLog().info((CharSequence)"no jsunit tests to run.");
            return;
        }
        this.unpackJavascriptDependency("net.jsunit:jsunit-testRunner", this.workDirectory);
        if (this.browsers == null) {
            this.browsers = this.DEFAULT_BROWSERS;
        }
        for (int i = 0; i < this.browsers.length; ++i) {
            if (new File(this.browsers[i]).exists()) continue;
            if ("firefox".equalsIgnoreCase(this.browsers[i])) {
                this.browsers[i] = this.firefoxPath;
            }
            if (!"iexplorer".equalsIgnoreCase(this.browsers[i])) continue;
            this.browsers[i] = this.iePath;
        }
        JsUnitServer server = new JsUnitServer();
        try {
            this.runJsUnitTests(server, tests);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to run JsUnit tests", e);
        }
        finally {
            try {
                server.stop();
            }
            catch (InterruptedException e) {}
        }
    }

    private void runJsUnitTests(JsUnitServer server, String[] tests) throws Exception {
        this.setupServer(server);
        FileReporter reporter = new FileReporter(this.reportsDirectory, Boolean.FALSE);
        ReporterManager reportManager = new ReporterManager(Collections.singletonList(reporter));
        ReportEntry report = new ReportEntry((Object)this, "jsunit", "test Starting");
        reportManager.testSetStarting(report);
        for (int i = 0; i < tests.length; ++i) {
            String test = tests[i];
            String path = this.workDirectory.toURI().getPath();
            String name = test.substring(0, test.lastIndexOf(46));
            if (test.toLowerCase().endsWith(".js")) {
                test = this.buildMinimalHtml(test);
            }
            server.setTestURL(new URL("file://" + path + "testRunner.html?autoRun=true&submitresults=true" + "&resultid=TEST-" + name + "&testPage=" + path.substring(1) + test));
            JsUnitTestCase.setSuite(new TestSuite(JsUnitTestCase.class, name));
            JUnitTestSet testSet = new JUnitTestSet(JsUnitTestCase.class);
            testSet.execute(reportManager, ((Object)((Object)this)).getClass().getClassLoader());
        }
        report = new ReportEntry((Object)this, "jsunit", "test Completed");
        reportManager.testSetCompleted(report);
        this.checkFailure(reportManager);
    }

    private String buildMinimalHtml(String test) throws IOException {
        String name = test.substring(0, test.lastIndexOf(46));
        String html = name + ".html";
        File file = new File(this.workDirectory, html);
        file.getParentFile().mkdirs();
        test = test.replace('\\', '/');
        String basedir = "";
        int i = 0;
        while ((i = test.indexOf("/")) > 0) {
            test = test.substring(i);
            basedir = basedir + "../";
        }
        if (basedir.trim().length() == 0) {
            basedir = ".";
        }
        FileWriter w = new FileWriter(file);
        w.write("<html>\n");
        w.write("<head>\n");
        w.write("<script type='text/javascript' src='" + basedir + "/app/jsUnitCore.js'></script>\n");
        w.write("<script type='text/javascript' src='" + test + "'></script>\n");
        w.write("</head>\n");
        w.write("<body>\n");
        w.write("</body>\n");
        w.write("</html>\n");
        IOUtil.close((Writer)w);
        return html;
    }

    private String[] getTestsToRun() {
        if (!this.testSourceDirectory.exists()) {
            return null;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.testSourceDirectory);
        scanner.setExcludes(this.excludes);
        scanner.addDefaultExcludes();
        if (this.includes == null) {
            this.includes = DEFAULT_INCLUDES;
        }
        scanner.setIncludes(this.includes);
        scanner.scan();
        String[] tests = scanner.getIncludedFiles();
        return tests;
    }

    private void checkFailure(ReporterManager reportManager) throws MojoFailureException {
        if (reportManager.getNumErrors() + reportManager.getNumFailures() > 0) {
            String msg = "There are test failures.\n\nPlease refer to " + this.reportsDirectory + " for the individual test results.";
            if (this.testFailureIgnore) {
                this.getLog().error((CharSequence)msg);
            } else {
                throw new MojoFailureException(msg);
            }
        }
    }

    private void setupServer(JsUnitServer server) throws ConfigurationException, MultiException {
        System.setProperty("url", "http://localhost:" + this.port + "/jsunit/");
        System.setProperty("port", String.valueOf(this.port));
        System.setProperty("logsDirectory", this.reportsDirectory.getAbsolutePath());
        server.initialize();
        server.setResourceBase(this.workDirectory);
        server.setLocalBrowserFileNames(Arrays.asList(this.browsers));
        server.start();
        JsUnitTestCase.setSharedServer(server);
    }
}

