/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript.test.qunit;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.surefire.report.FileReporter;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.XMLReporter;
import org.codehaus.mojo.javascript.AbstractJavascriptMojo;
import org.codehaus.mojo.javascript.test.qunit.ReportCallbacks;
import org.codehaus.mojo.javascript.test.qunit.RhinoRuntime;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractRhinoTestMojo
extends AbstractJavascriptMojo {
    boolean skip;
    boolean testFailureIgnore;
    File reportsDirectory;
    File suiteDirectory;
    protected File outputDirectory;
    File workDirectory;
    String[] excludes;
    String[] includes;
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/suite-*.html"};

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().warn((CharSequence)"tests are skipped.");
            return;
        }
        String[] suites = this.getTestsToRun();
        if (suites.length == 0) {
            this.getLog().info((CharSequence)"No tests to run.");
            return;
        }
        this.reportsDirectory.mkdirs();
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        if (this.workDirectory == null) {
            this.workDirectory = FileUtils.createTempFile((String)"test", (String)"work", (File)outputDirectory);
            this.workDirectory.deleteOnExit();
        } else {
            if (this.workDirectory.exists()) {
                throw new MojoFailureException("workDirectory [" + this.workDirectory + "] already exists, and it should not.");
            }
            this.workDirectory.mkdirs();
        }
        try {
            FileUtils.copyDirectoryStructure((File)outputDirectory, (File)this.workDirectory);
        }
        catch (IOException ex) {
            throw new MojoFailureException("Could not create workDirectory from suiteDirectory [" + this.suiteDirectory + "]");
        }
        try {
            FileUtils.copyDirectoryStructure((File)this.suiteDirectory, (File)this.workDirectory);
        }
        catch (IOException ex) {
            throw new MojoFailureException("Could not create workDirectory from suiteDirectory [" + this.suiteDirectory + "]");
        }
        File libDirectory = new File(this.workDirectory, "lib");
        libDirectory.mkdirs();
        this.unpackJavascriptDependency("com.devspan.vendor.envjs:envjs-rhino", libDirectory, true);
        this.unpackJavascriptDependency("com.devspan.vendor.jquery:qunit", libDirectory, true);
        this.unpackJavascriptDependency("com.devspan.vendor.jquery:jquery", libDirectory, true);
        try {
            this.javascriptArtifactManager.unpack(this.project, "test", libDirectory, true);
        }
        catch (ArchiverException ex) {
            throw new MojoFailureException("Could not unpack dependencies");
        }
        for (String suiteName : suites) {
            RhinoRuntime rt;
            this.getLog().info((CharSequence)("Running suite: " + suiteName));
            File suite = new File(this.workDirectory, suiteName);
            ReporterManager reporterManager = new ReporterManager(Arrays.asList(new FileReporter(this.reportsDirectory, Boolean.FALSE), new XMLReporter(this.reportsDirectory, Boolean.FALSE)));
            ReportCallbacks reportCb = new ReportCallbacks(reporterManager);
            try {
                rt = this.createRhinoRuntime(reportCb);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not create the Rhino runtime.", e);
            }
            try {
                this.runSuite(rt, suite);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error running test suite '" + suite.getAbsolutePath() + "'.", e);
            }
            this.checkFailure(reporterManager);
        }
    }

    protected RhinoRuntime createRhinoRuntime(ReportCallbacks reportCb) throws Exception {
        RhinoRuntime rt = new RhinoRuntime();
        rt.putGlobal("$report", reportCb);
        rt.execScriptFile(new File(this.workDirectory, "lib/envjs-rhino/env.rhino.js"));
        return rt;
    }

    protected abstract void runSuite(RhinoRuntime var1, File var2) throws Exception;

    private String[] getTestsToRun() {
        if (!this.suiteDirectory.exists()) {
            this.getLog().warn((CharSequence)"No suite directory exists");
            return new String[0];
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.suiteDirectory);
        scanner.setExcludes(this.excludes);
        scanner.addDefaultExcludes();
        if (this.includes == null) {
            this.includes = DEFAULT_INCLUDES;
        }
        scanner.setIncludes(this.includes);
        scanner.scan();
        String[] tests = scanner.getIncludedFiles();
        return tests;
    }

    private void checkFailure(ReporterManager reportManager) throws MojoFailureException {
        if (reportManager.getNumErrors() + reportManager.getNumFailures() > 0) {
            String msg = "There are test failures.\n\nPlease refer to " + this.reportsDirectory + " for the individual test results.";
            if (this.testFailureIgnore) {
                this.getLog().error((CharSequence)msg);
            } else {
                throw new MojoFailureException(msg);
            }
        }
    }
}

