/*
 * Decompiled with CFR 0.152.
 */
package com.github.antlrjavaparser.api.visitor;

import com.github.antlrjavaparser.api.Comment;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommentFormatter {
    private static Pattern commentFormattingRegex = Pattern.compile("[\\s]*(.+)\\r?\\n?");

    public String format(Comment comment, int indentLevel) {
        if (comment == null || comment.getContent() == null) {
            return null;
        }
        return this.format(comment.getContent(), indentLevel);
    }

    public String format(String comment, int indentLevel) {
        if (comment == null) {
            return null;
        }
        StringBuilder indentString = new StringBuilder();
        for (int i = 0; i < indentLevel; ++i) {
            indentString.append("    ");
        }
        boolean endsWithNewline = comment.endsWith("\r\n") || comment.endsWith("\n");
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher regexMatcher = commentFormattingRegex.matcher(comment);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group());
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < matchList.size(); ++i) {
            if (i == matchList.size() - 1) {
                builder.append(indentString.toString() + " " + ((String)matchList.get(i)).trim() + (endsWithNewline ? "\n" : ""));
                continue;
            }
            if (i == 0) {
                builder.append(indentString.toString() + ((String)matchList.get(i)).trim() + "\n");
                continue;
            }
            builder.append(indentString.toString() + " " + ((String)matchList.get(i)).trim() + "\n");
        }
        return builder.toString();
    }

    public String formatStringAsJavadoc(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder finalComment = new StringBuilder("/**\n");
        Matcher regexMatcher = commentFormattingRegex.matcher(input);
        while (regexMatcher.find()) {
            finalComment.append("* ");
            finalComment.append(regexMatcher.group());
        }
        finalComment.append("\n*/\n");
        return finalComment.toString();
    }
}

