/*
 * Decompiled with CFR 0.152.
 */
package com.github.antlrjavaparser.adapter;

import com.github.antlrjavaparser.ASTHelper;
import com.github.antlrjavaparser.Java7Parser;
import com.github.antlrjavaparser.adapter.Adapter;
import com.github.antlrjavaparser.adapter.AdapterParameters;
import com.github.antlrjavaparser.adapter.Adapters;
import com.github.antlrjavaparser.api.BlockComment;
import com.github.antlrjavaparser.api.Comment;
import com.github.antlrjavaparser.api.LineComment;
import com.github.antlrjavaparser.api.Node;
import com.github.antlrjavaparser.api.body.AnnotationMemberDeclaration;
import com.github.antlrjavaparser.api.body.BodyDeclaration;
import com.github.antlrjavaparser.api.body.CatchParameter;
import com.github.antlrjavaparser.api.body.ConstructorDeclaration;
import com.github.antlrjavaparser.api.body.FieldDeclaration;
import com.github.antlrjavaparser.api.body.JavadocComment;
import com.github.antlrjavaparser.api.body.MethodDeclaration;
import com.github.antlrjavaparser.api.body.Parameter;
import com.github.antlrjavaparser.api.body.Resource;
import com.github.antlrjavaparser.api.body.TypeDeclaration;
import com.github.antlrjavaparser.api.expr.AnnotationExpr;
import com.github.antlrjavaparser.api.expr.BinaryExpr;
import com.github.antlrjavaparser.api.expr.Expression;
import com.github.antlrjavaparser.api.expr.NameExpr;
import com.github.antlrjavaparser.api.type.ClassOrInterfaceType;
import com.github.antlrjavaparser.api.type.ReferenceType;
import com.github.antlrjavaparser.api.type.Type;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdapterUtil {
    private AdapterUtil() {
    }

    public static String dottedIdentifier(List<TerminalNode> terminalNodeList) {
        String identifier = "";
        for (int i = 0; i < terminalNodeList.size(); ++i) {
            identifier = identifier + (i > 0 ? "." : "") + terminalNodeList.get(i).getText();
        }
        return identifier;
    }

    public static NameExpr qualifiedName(List<TerminalNode> terminalNodeList) {
        String qualifiedName = AdapterUtil.dottedIdentifier(terminalNodeList);
        return ASTHelper.createNameExpr(qualifiedName);
    }

    public static void setVariableModifiers(Java7Parser.VariableModifiersContext context, Resource resource, AdapterParameters adapterParameters) {
        List<AnnotationExpr> annotations = AdapterUtil.getAnnotations(context, adapterParameters);
        int modifiers = 0;
        if (AdapterUtil.hasModifier(context.FINAL())) {
            modifiers |= 0x10;
        }
        resource.setAnnotations(annotations);
        resource.setModifiers(modifiers);
    }

    public static void setVariableModifiers(Java7Parser.VariableModifiersContext context, Parameter parameter, AdapterParameters adapterParameters) {
        List<AnnotationExpr> annotations = AdapterUtil.getAnnotations(context, adapterParameters);
        int modifiers = 0;
        if (AdapterUtil.hasModifier(context.FINAL())) {
            modifiers |= 0x10;
        }
        parameter.setAnnotations(annotations);
        parameter.setModifiers(modifiers);
    }

    public static void setVariableModifiers(Java7Parser.VariableModifiersContext context, CatchParameter parameter, AdapterParameters adapterParameters) {
        int modifiers = 0;
        List<AnnotationExpr> annotations = AdapterUtil.getAnnotations(context, adapterParameters);
        if (AdapterUtil.hasModifier(context.FINAL())) {
            modifiers |= 0x10;
        }
        parameter.setAnnotations(annotations);
        parameter.setModifiers(modifiers);
    }

    private static List<AnnotationExpr> getAnnotations(Java7Parser.VariableModifiersContext context, AdapterParameters adapterParameters) {
        LinkedList<AnnotationExpr> annotations = new LinkedList<AnnotationExpr>();
        for (Java7Parser.AnnotationContext annotationContext : context.annotation()) {
            AnnotationExpr annotationExpr = Adapters.getAnnotationContextAdapter().adapt(annotationContext, adapterParameters);
            annotations.add(annotationExpr);
        }
        return annotations;
    }

    private static void setModifiersByType(BodyDeclaration bodyDeclaration, int modifiers) {
        if (bodyDeclaration instanceof TypeDeclaration) {
            ((TypeDeclaration)bodyDeclaration).setModifiers(modifiers);
        } else if (bodyDeclaration instanceof MethodDeclaration) {
            ((MethodDeclaration)bodyDeclaration).setModifiers(modifiers);
        } else if (bodyDeclaration instanceof ConstructorDeclaration) {
            ((ConstructorDeclaration)bodyDeclaration).setModifiers(modifiers);
        } else if (bodyDeclaration instanceof FieldDeclaration) {
            ((FieldDeclaration)bodyDeclaration).setModifiers(modifiers);
        } else if (bodyDeclaration instanceof AnnotationMemberDeclaration) {
            ((AnnotationMemberDeclaration)bodyDeclaration).setModifiers(modifiers);
        } else {
            throw new RuntimeException("Unknown type to set modifiers: " + bodyDeclaration.getClass().getName());
        }
    }

    public static void setModifiers(Java7Parser.ModifiersContext modifiersContext, BodyDeclaration typeDeclaration, AdapterParameters adapterParameters) {
        if (modifiersContext != null && modifiersContext.modifier() != null) {
            AdapterUtil.setModifiers(modifiersContext.modifier(), typeDeclaration, adapterParameters);
        }
    }

    public static void setModifiers(List<Java7Parser.ModifierContext> modifierList, BodyDeclaration typeDeclaration, AdapterParameters adapterParameters) {
        int modifiers = 0;
        LinkedList<AnnotationExpr> annotations = new LinkedList<AnnotationExpr>();
        for (Java7Parser.ModifierContext modifierContext : modifierList) {
            if (AdapterUtil.hasModifier(modifierContext.PUBLIC())) {
                modifiers |= 1;
            }
            if (AdapterUtil.hasModifier(modifierContext.PROTECTED())) {
                modifiers |= 4;
            }
            if (AdapterUtil.hasModifier(modifierContext.PRIVATE())) {
                modifiers |= 2;
            }
            if (AdapterUtil.hasModifier(modifierContext.ABSTRACT())) {
                modifiers |= 0x400;
            }
            if (AdapterUtil.hasModifier(modifierContext.STATIC())) {
                modifiers |= 8;
            }
            if (AdapterUtil.hasModifier(modifierContext.FINAL())) {
                modifiers |= 0x10;
            }
            if (AdapterUtil.hasModifier(modifierContext.STRICTFP())) {
                modifiers |= 0x800;
            }
            if (modifierContext.annotation() != null) {
                AnnotationExpr annotationExpr = Adapters.getAnnotationContextAdapter().adapt(modifierContext.annotation(), adapterParameters);
                annotations.add(annotationExpr);
            }
            AdapterUtil.setComments(typeDeclaration, modifierContext, adapterParameters);
        }
        typeDeclaration.setAnnotations(annotations);
        AdapterUtil.setModifiersByType(typeDeclaration, modifiers);
    }

    private static boolean hasModifier(TerminalNode modifier) {
        return modifier != null;
    }

    public static List<ClassOrInterfaceType> convertTypeList(List<Type> typeList) {
        if (typeList == null) {
            return null;
        }
        LinkedList<ClassOrInterfaceType> classOrInterfaceTypeList = new LinkedList<ClassOrInterfaceType>();
        for (Type type : typeList) {
            if (type instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)type;
                classOrInterfaceTypeList.add((ClassOrInterfaceType)referenceType.getType());
                continue;
            }
            classOrInterfaceTypeList.add((ClassOrInterfaceType)type);
        }
        return classOrInterfaceTypeList;
    }

    public static <C> Expression handleExpression(Adapter<Expression, C> adapter, List<C> contextList, BinaryExpr.Operator operator, AdapterParameters adapterParameters) {
        Expression expression = adapter.adapt(contextList.get(0), adapterParameters);
        AdapterUtil.setComments(expression, (ParserRuleContext)contextList.get(0), adapterParameters);
        if (contextList.size() > 1) {
            BinaryExpr root = new BinaryExpr();
            root.setLeft(expression);
            root.setOperator(operator);
            BinaryExpr currentExpression = root;
            for (int i = 1; i < contextList.size(); ++i) {
                Expression rightExpression = adapter.adapt(contextList.get(i), adapterParameters);
                AdapterUtil.setComments(rightExpression, (ParserRuleContext)contextList.get(i), adapterParameters);
                currentExpression.setRight(rightExpression);
                if (i >= contextList.size() - 1) continue;
                BinaryExpr binaryExpr = new BinaryExpr();
                binaryExpr.setLeft(currentExpression);
                binaryExpr.setOperator(operator);
                currentExpression = binaryExpr;
            }
            return currentExpression;
        }
        return expression;
    }

    public static <T> List<T> singleElementList(T element) {
        LinkedList<T> newElementList = new LinkedList<T>();
        newElementList.add(element);
        return newElementList;
    }

    public static void setInternalComments(Node node, ParserRuleContext parserRuleContext, AdapterParameters adapterParameters) {
        BufferedTokenStream tokens = adapterParameters.getTokens();
        if (node == null || parserRuleContext == null || tokens == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        Token startToken = parserRuleContext.getStart();
        Token stopToken = parserRuleContext.getStop();
        LinkedList<Comment> internalCommentList = new LinkedList<Comment>();
        List commentTokens = tokens.getHiddenTokensToRight(startToken.getTokenIndex(), 2);
        if (commentTokens != null) {
            for (Token commentToken : commentTokens) {
                if (adapterParameters.isCommentTokenClaimed(commentToken.getTokenIndex())) continue;
                adapterParameters.claimCommentToken(commentToken.getTokenIndex());
                if (commentToken.getText().startsWith("/**")) {
                    JavadocComment javadocComment = new JavadocComment(commentToken.getText());
                    internalCommentList.add(javadocComment);
                    continue;
                }
                if (commentToken.getText().startsWith("/*")) {
                    BlockComment blockComment = new BlockComment(commentToken.getText());
                    internalCommentList.add(blockComment);
                    continue;
                }
                if (!commentToken.getText().startsWith("//")) continue;
                LineComment lineComment = new LineComment(commentToken.getText());
                internalCommentList.add(lineComment);
            }
        }
        if (internalCommentList.size() > 0) {
            if (node.getInternalComments() != null) {
                node.getInternalComments().addAll(internalCommentList);
            } else {
                node.setInternalComments(internalCommentList);
            }
        }
    }

    public static void setComments(Node node, ParserRuleContext parserRuleContext, AdapterParameters adapterParameters) {
        LineComment lineComment;
        BlockComment blockComment;
        JavadocComment javadocComment;
        BufferedTokenStream tokens = adapterParameters.getTokens();
        if (node == null || parserRuleContext == null || tokens == null) {
            return;
        }
        Token startToken = parserRuleContext.getStart();
        Token stopToken = parserRuleContext.getStop();
        LinkedList<Comment> beginCommentList = new LinkedList<Comment>();
        LinkedList<Comment> endCommentList = new LinkedList<Comment>();
        List commentTokens = tokens.getHiddenTokensToLeft(startToken.getTokenIndex(), 2);
        if (commentTokens != null) {
            for (Token commentToken : commentTokens) {
                if (adapterParameters.isCommentTokenClaimed(commentToken.getTokenIndex())) continue;
                adapterParameters.claimCommentToken(commentToken.getTokenIndex());
                if (commentToken.getText().trim().startsWith("/**")) {
                    javadocComment = new JavadocComment(commentToken.getText());
                    beginCommentList.add(javadocComment);
                    continue;
                }
                if (commentToken.getText().trim().startsWith("/*")) {
                    blockComment = new BlockComment(commentToken.getText());
                    beginCommentList.add(blockComment);
                    continue;
                }
                if (!commentToken.getText().trim().startsWith("//")) continue;
                lineComment = new LineComment(commentToken.getText());
                beginCommentList.add(lineComment);
            }
        }
        if ((commentTokens = tokens.getHiddenTokensToRight(stopToken.getTokenIndex(), 2)) != null) {
            for (Token commentToken : commentTokens) {
                if (commentToken.getLine() != stopToken.getLine() || adapterParameters.isCommentTokenClaimed(commentToken.getTokenIndex())) continue;
                adapterParameters.claimCommentToken(commentToken.getTokenIndex());
                if (commentToken.getText().trim().startsWith("/**")) {
                    javadocComment = new JavadocComment(commentToken.getText());
                    endCommentList.add(javadocComment);
                    continue;
                }
                if (commentToken.getText().trim().startsWith("/*")) {
                    blockComment = new BlockComment(commentToken.getText());
                    endCommentList.add(blockComment);
                    continue;
                }
                if (!commentToken.getText().trim().startsWith("//")) continue;
                lineComment = new LineComment(commentToken.getText());
                endCommentList.add(lineComment);
            }
        }
        if (beginCommentList.size() > 0) {
            if (node.getBeginComments() != null) {
                node.getBeginComments().addAll(beginCommentList);
            } else {
                node.setBeginComments(beginCommentList);
            }
        }
        if (endCommentList.size() > 0) {
            if (node.getEndComments() != null) {
                node.getEndComments().addAll(endCommentList);
            } else {
                node.setEndComments(endCommentList);
            }
        }
    }
}

