/*
 * Decompiled with CFR 0.152.
 */
package com.github.antlrjavaparser.adapter;

import com.github.antlrjavaparser.Java7Parser;
import com.github.antlrjavaparser.adapter.Adapter;
import com.github.antlrjavaparser.adapter.AdapterParameters;
import com.github.antlrjavaparser.adapter.AdapterUtil;
import com.github.antlrjavaparser.api.expr.BooleanLiteralExpr;
import com.github.antlrjavaparser.api.expr.CharLiteralExpr;
import com.github.antlrjavaparser.api.expr.DoubleLiteralExpr;
import com.github.antlrjavaparser.api.expr.IntegerLiteralExpr;
import com.github.antlrjavaparser.api.expr.LiteralExpr;
import com.github.antlrjavaparser.api.expr.LongLiteralExpr;
import com.github.antlrjavaparser.api.expr.NullLiteralExpr;
import com.github.antlrjavaparser.api.expr.StringLiteralExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralContextAdapter
implements Adapter<LiteralExpr, Java7Parser.LiteralContext> {
    @Override
    public LiteralExpr adapt(Java7Parser.LiteralContext context, AdapterParameters adapterParameters) {
        LiteralExpr literalExpr;
        if (context.IntegerLiteral() != null) {
            literalExpr = this.isLongType(context.IntegerLiteral().getText()) ? new LongLiteralExpr(context.IntegerLiteral().getText()) : new IntegerLiteralExpr(context.IntegerLiteral().getText());
        } else if (context.FloatingPointLiteral() != null) {
            literalExpr = new DoubleLiteralExpr(context.FloatingPointLiteral().getText());
        } else if (context.CharacterLiteral() != null) {
            literalExpr = new CharLiteralExpr(this.stripQuotes(context.CharacterLiteral().getText()));
        } else if (context.StringLiteral() != null) {
            literalExpr = new StringLiteralExpr(this.stripQuotes(context.StringLiteral().getText()));
        } else if (context.TRUE() != null) {
            literalExpr = new BooleanLiteralExpr(true);
        } else if (context.FALSE() != null) {
            literalExpr = new BooleanLiteralExpr(false);
        } else if (context.NULL() != null) {
            literalExpr = new NullLiteralExpr();
        } else {
            throw new RuntimeException("Unknown Literal Context");
        }
        AdapterUtil.setComments(literalExpr, context, adapterParameters);
        AdapterUtil.setPosition(literalExpr, context);
        return literalExpr;
    }

    private boolean isLongType(String value) {
        return value.endsWith("l") || value.endsWith("L");
    }

    private String stripQuotes(String str) {
        return str.substring(1, str.length() - 1);
    }
}

