/*
 * Decompiled with CFR 0.152.
 */
package com.github.antlrjavaparser.adapter;

import com.github.antlrjavaparser.Java7Parser;
import com.github.antlrjavaparser.adapter.Adapter;
import com.github.antlrjavaparser.adapter.AdapterParameters;
import com.github.antlrjavaparser.adapter.Adapters;
import com.github.antlrjavaparser.api.expr.BinaryExpr;
import com.github.antlrjavaparser.api.expr.Expression;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiftExpressionContextAdapter
implements Adapter<Expression, Java7Parser.ShiftExpressionContext> {
    @Override
    public Expression adapt(Java7Parser.ShiftExpressionContext context, AdapterParameters adapterParameters) {
        List<Java7Parser.AdditiveExpressionContext> contextList = context.additiveExpression();
        Expression expression = Adapters.getAdditiveExpressionContextAdapter().adapt(contextList.get(0), adapterParameters);
        if (contextList.size() > 1) {
            BinaryExpr root = new BinaryExpr();
            root.setLeft(expression);
            root.setOperator(this.getOperator(context.shiftOp(0)));
            BinaryExpr currentExpression = root;
            for (int i = 1; i < contextList.size(); ++i) {
                currentExpression.setRight(Adapters.getAdditiveExpressionContextAdapter().adapt(contextList.get(i), adapterParameters));
                if (i >= contextList.size() - 1) continue;
                BinaryExpr binaryExpr = new BinaryExpr();
                binaryExpr.setLeft(currentExpression);
                binaryExpr.setOperator(this.getOperator(context.shiftOp(i)));
                currentExpression = binaryExpr;
            }
            return currentExpression;
        }
        return expression;
    }

    private BinaryExpr.Operator getOperator(Java7Parser.ShiftOpContext operatorContext) {
        switch (operatorContext.operatorType) {
            case 1: {
                return BinaryExpr.Operator.lShift;
            }
            case 2: {
                return BinaryExpr.Operator.rUnsignedShift;
            }
            case 3: {
                return BinaryExpr.Operator.rSignedShift;
            }
        }
        return null;
    }
}

