/*
 * Decompiled with CFR 0.152.
 */
package com.github.antlrjavaparser.api.visitor;

import com.github.antlrjavaparser.api.BlockComment;
import com.github.antlrjavaparser.api.Comment;
import com.github.antlrjavaparser.api.CompilationUnit;
import com.github.antlrjavaparser.api.ImportDeclaration;
import com.github.antlrjavaparser.api.LineComment;
import com.github.antlrjavaparser.api.Node;
import com.github.antlrjavaparser.api.PackageDeclaration;
import com.github.antlrjavaparser.api.TypeParameter;
import com.github.antlrjavaparser.api.body.AnnotationDeclaration;
import com.github.antlrjavaparser.api.body.AnnotationMemberDeclaration;
import com.github.antlrjavaparser.api.body.BodyDeclaration;
import com.github.antlrjavaparser.api.body.CatchParameter;
import com.github.antlrjavaparser.api.body.ClassOrInterfaceDeclaration;
import com.github.antlrjavaparser.api.body.ConstructorDeclaration;
import com.github.antlrjavaparser.api.body.EmptyMemberDeclaration;
import com.github.antlrjavaparser.api.body.EmptyTypeDeclaration;
import com.github.antlrjavaparser.api.body.EnumConstantDeclaration;
import com.github.antlrjavaparser.api.body.EnumDeclaration;
import com.github.antlrjavaparser.api.body.FieldDeclaration;
import com.github.antlrjavaparser.api.body.InitializerDeclaration;
import com.github.antlrjavaparser.api.body.JavadocComment;
import com.github.antlrjavaparser.api.body.MethodDeclaration;
import com.github.antlrjavaparser.api.body.ModifierSet;
import com.github.antlrjavaparser.api.body.Parameter;
import com.github.antlrjavaparser.api.body.Resource;
import com.github.antlrjavaparser.api.body.TypeDeclaration;
import com.github.antlrjavaparser.api.body.VariableDeclarator;
import com.github.antlrjavaparser.api.body.VariableDeclaratorId;
import com.github.antlrjavaparser.api.expr.AnnotationExpr;
import com.github.antlrjavaparser.api.expr.ArrayAccessExpr;
import com.github.antlrjavaparser.api.expr.ArrayCreationExpr;
import com.github.antlrjavaparser.api.expr.ArrayInitializerExpr;
import com.github.antlrjavaparser.api.expr.AssignExpr;
import com.github.antlrjavaparser.api.expr.BinaryExpr;
import com.github.antlrjavaparser.api.expr.BooleanLiteralExpr;
import com.github.antlrjavaparser.api.expr.CastExpr;
import com.github.antlrjavaparser.api.expr.CharLiteralExpr;
import com.github.antlrjavaparser.api.expr.ClassExpr;
import com.github.antlrjavaparser.api.expr.ConditionalExpr;
import com.github.antlrjavaparser.api.expr.DoubleLiteralExpr;
import com.github.antlrjavaparser.api.expr.EnclosedExpr;
import com.github.antlrjavaparser.api.expr.Expression;
import com.github.antlrjavaparser.api.expr.FieldAccessExpr;
import com.github.antlrjavaparser.api.expr.InstanceOfExpr;
import com.github.antlrjavaparser.api.expr.IntegerLiteralExpr;
import com.github.antlrjavaparser.api.expr.IntegerLiteralMinValueExpr;
import com.github.antlrjavaparser.api.expr.LambdaExpr;
import com.github.antlrjavaparser.api.expr.LongLiteralExpr;
import com.github.antlrjavaparser.api.expr.LongLiteralMinValueExpr;
import com.github.antlrjavaparser.api.expr.MarkerAnnotationExpr;
import com.github.antlrjavaparser.api.expr.MemberValuePair;
import com.github.antlrjavaparser.api.expr.MethodCallExpr;
import com.github.antlrjavaparser.api.expr.MethodReferenceExpr;
import com.github.antlrjavaparser.api.expr.NameExpr;
import com.github.antlrjavaparser.api.expr.NormalAnnotationExpr;
import com.github.antlrjavaparser.api.expr.NullLiteralExpr;
import com.github.antlrjavaparser.api.expr.ObjectCreationExpr;
import com.github.antlrjavaparser.api.expr.QualifiedNameExpr;
import com.github.antlrjavaparser.api.expr.SingleMemberAnnotationExpr;
import com.github.antlrjavaparser.api.expr.StringLiteralExpr;
import com.github.antlrjavaparser.api.expr.SuperExpr;
import com.github.antlrjavaparser.api.expr.ThisExpr;
import com.github.antlrjavaparser.api.expr.UnaryExpr;
import com.github.antlrjavaparser.api.expr.VariableDeclarationExpr;
import com.github.antlrjavaparser.api.stmt.AssertStmt;
import com.github.antlrjavaparser.api.stmt.BlockStmt;
import com.github.antlrjavaparser.api.stmt.BreakStmt;
import com.github.antlrjavaparser.api.stmt.CatchClause;
import com.github.antlrjavaparser.api.stmt.ContinueStmt;
import com.github.antlrjavaparser.api.stmt.DoStmt;
import com.github.antlrjavaparser.api.stmt.EmptyStmt;
import com.github.antlrjavaparser.api.stmt.ExplicitConstructorInvocationStmt;
import com.github.antlrjavaparser.api.stmt.ExpressionStmt;
import com.github.antlrjavaparser.api.stmt.ForStmt;
import com.github.antlrjavaparser.api.stmt.ForeachStmt;
import com.github.antlrjavaparser.api.stmt.IfStmt;
import com.github.antlrjavaparser.api.stmt.LabeledStmt;
import com.github.antlrjavaparser.api.stmt.ReturnStmt;
import com.github.antlrjavaparser.api.stmt.Statement;
import com.github.antlrjavaparser.api.stmt.SwitchEntryStmt;
import com.github.antlrjavaparser.api.stmt.SwitchStmt;
import com.github.antlrjavaparser.api.stmt.SynchronizedStmt;
import com.github.antlrjavaparser.api.stmt.ThrowStmt;
import com.github.antlrjavaparser.api.stmt.TryStmt;
import com.github.antlrjavaparser.api.stmt.TypeDeclarationStmt;
import com.github.antlrjavaparser.api.stmt.WhileStmt;
import com.github.antlrjavaparser.api.type.ClassOrInterfaceType;
import com.github.antlrjavaparser.api.type.PrimitiveType;
import com.github.antlrjavaparser.api.type.ReferenceType;
import com.github.antlrjavaparser.api.type.Type;
import com.github.antlrjavaparser.api.type.VoidType;
import com.github.antlrjavaparser.api.type.WildcardType;
import com.github.antlrjavaparser.api.visitor.CommentFormatter;
import com.github.antlrjavaparser.api.visitor.VoidVisitor;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DumpVisitor
implements VoidVisitor<Object> {
    private static final CommentFormatter commentFormatter = new CommentFormatter();
    private final SourcePrinter printer = new SourcePrinter();

    public String getSource() {
        return this.printer.getSource();
    }

    private void printModifiers(int modifiers) {
        if (ModifierSet.isPrivate(modifiers)) {
            this.printer.print("private ");
        }
        if (ModifierSet.isProtected(modifiers)) {
            this.printer.print("protected ");
        }
        if (ModifierSet.isPublic(modifiers)) {
            this.printer.print("public ");
        }
        if (ModifierSet.isAbstract(modifiers)) {
            this.printer.print("abstract ");
        }
        if (ModifierSet.isStatic(modifiers)) {
            this.printer.print("static ");
        }
        if (ModifierSet.isFinal(modifiers)) {
            this.printer.print("final ");
        }
        if (ModifierSet.isNative(modifiers)) {
            this.printer.print("native ");
        }
        if (ModifierSet.isStrictfp(modifiers)) {
            this.printer.print("strictfp ");
        }
        if (ModifierSet.isSynchronized(modifiers)) {
            this.printer.print("synchronized ");
        }
        if (ModifierSet.isTransient(modifiers)) {
            this.printer.print("transient ");
        }
        if (ModifierSet.isVolatile(modifiers)) {
            this.printer.print("volatile ");
        }
    }

    private void printMembers(List<BodyDeclaration> members, Object arg) {
        for (BodyDeclaration member : members) {
            this.printer.printLn();
            member.accept(this, arg);
            this.printer.printLn();
        }
    }

    private void printMemberAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (annotations != null) {
            for (AnnotationExpr a : annotations) {
                a.accept(this, arg);
                this.printer.printLn();
            }
        }
    }

    private void printAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (annotations != null) {
            for (AnnotationExpr a : annotations) {
                a.accept(this, arg);
                this.printer.print(" ");
            }
        }
    }

    private void printTypeArgs(List<Type> args, Object arg) {
        if (args != null) {
            this.printer.print("<");
            Iterator<Type> i = args.iterator();
            while (i.hasNext()) {
                Type t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printTypeParameters(List<TypeParameter> args, Object arg) {
        if (args != null) {
            this.printer.print("<");
            Iterator<TypeParameter> i = args.iterator();
            while (i.hasNext()) {
                TypeParameter t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printArguments(List<Expression> args, Object arg) {
        this.printer.print("(");
        if (args != null) {
            Iterator<Expression> i = args.iterator();
            while (i.hasNext()) {
                Expression e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    private void printJavadoc(JavadocComment javadoc, Object arg) {
        if (javadoc != null) {
            javadoc.accept(this, arg);
        }
    }

    @Override
    public void visit(CompilationUnit n, Object arg) {
        if (n.getPackage() != null) {
            n.getPackage().accept(this, arg);
        }
        if (n.getImports() != null) {
            for (ImportDeclaration i : n.getImports()) {
                i.accept(this, arg);
            }
            this.printer.printLn();
        }
        if (n.getTypes() != null) {
            Iterator<TypeDeclaration> i = n.getTypes().iterator();
            while (i.hasNext()) {
                i.next().accept(this, arg);
                this.printer.printLn();
                if (!i.hasNext()) continue;
                this.printer.printLn();
            }
        }
    }

    @Override
    public void visit(PackageDeclaration n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printer.print("package ");
        n.getName().accept(this, arg);
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
        this.printer.printLn();
    }

    @Override
    public void visit(NameExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(n.getName());
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(QualifiedNameExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getQualifier().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getName());
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ImportDeclaration n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("import ");
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getName().accept(this, arg);
        if (n.isAsterisk()) {
            this.printer.print(".*");
        }
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
        this.printer.printLn();
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        ClassOrInterfaceType c;
        Iterator<ClassOrInterfaceType> i;
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printBeginComments(n.getBeginComments(), arg);
        this.printModifiers(n.getModifiers());
        if (n.isInterface()) {
            this.printer.print("interface ");
        } else {
            this.printer.print("class ");
        }
        this.printer.print(n.getName());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getExtends() != null) {
            this.printer.print(" extends ");
            i = n.getExtends().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getImplements() != null) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getMembers() != null) {
            this.printMembers(n.getMembers(), arg);
        }
        this.printer.unindent();
        this.printer.print("}");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(EmptyTypeDeclaration n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(JavadocComment n, Object arg) {
        this.printer.print("/**");
        this.printer.print(n.getContent());
        this.printer.printLn("*/");
    }

    @Override
    public void visit(ClassOrInterfaceType n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print(n.getName());
        this.printTypeArgs(n.getTypeArgs(), arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(TypeParameter n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(n.getName());
        if (n.getTypeBound() != null) {
            this.printer.print(" extends ");
            Iterator<ClassOrInterfaceType> i = n.getTypeBound().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(" & ");
            }
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(PrimitiveType n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        switch (n.getType()) {
            case Boolean: {
                this.printer.print("boolean");
                break;
            }
            case Byte: {
                this.printer.print("byte");
                break;
            }
            case Char: {
                this.printer.print("char");
                break;
            }
            case Double: {
                this.printer.print("double");
                break;
            }
            case Float: {
                this.printer.print("float");
                break;
            }
            case Int: {
                this.printer.print("int");
                break;
            }
            case Long: {
                this.printer.print("long");
                break;
            }
            case Short: {
                this.printer.print("short");
            }
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ReferenceType n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getType().accept(this, arg);
        for (int i = 0; i < n.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(WildcardType n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("?");
        if (n.getExtends() != null) {
            this.printer.print(" extends ");
            n.getExtends().accept(this, arg);
        }
        if (n.getSuper() != null) {
            this.printer.print(" super ");
            n.getSuper().accept(this, arg);
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(FieldDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printBeginComments(n.getBeginComments(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVariables().iterator();
        while (i.hasNext()) {
            VariableDeclarator var = i.next();
            var.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(VariableDeclarator n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getId().accept(this, arg);
        if (n.getInit() != null) {
            this.printer.print(" = ");
            n.getInit().accept(this, arg);
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(VariableDeclaratorId n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(n.getName());
        for (int i = 0; i < n.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ArrayInitializerExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("{");
        if (n.getValues() != null) {
            this.printer.print(" ");
            Iterator<Expression> i = n.getValues().iterator();
            while (i.hasNext()) {
                Expression expr = i.next();
                expr.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(" ");
        }
        this.printer.print("}");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(VoidType n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("void");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ArrayAccessExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getName().accept(this, arg);
        this.printer.print("[");
        n.getIndex().accept(this, arg);
        this.printer.print("]");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ArrayCreationExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("new ");
        n.getType().accept(this, arg);
        if (n.getDimensions() != null) {
            for (Expression dim : n.getDimensions()) {
                this.printer.print("[");
                dim.accept(this, arg);
                this.printer.print("]");
            }
            for (int i = 0; i < n.getArrayCount(); ++i) {
                this.printer.print("[]");
            }
        } else {
            for (int i = 0; i < n.getArrayCount(); ++i) {
                this.printer.print("[]");
            }
            this.printer.print(" ");
            n.getInitializer().accept(this, arg);
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(AssignExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getTarget().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case assign: {
                this.printer.print("=");
                break;
            }
            case and: {
                this.printer.print("&=");
                break;
            }
            case or: {
                this.printer.print("|=");
                break;
            }
            case xor: {
                this.printer.print("^=");
                break;
            }
            case plus: {
                this.printer.print("+=");
                break;
            }
            case minus: {
                this.printer.print("-=");
                break;
            }
            case rem: {
                this.printer.print("%=");
                break;
            }
            case slash: {
                this.printer.print("/=");
                break;
            }
            case star: {
                this.printer.print("*=");
                break;
            }
            case lShift: {
                this.printer.print("<<=");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>=");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>=");
            }
        }
        this.printer.print(" ");
        n.getValue().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(BinaryExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getLeft().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case or: {
                this.printer.print("||");
                break;
            }
            case and: {
                this.printer.print("&&");
                break;
            }
            case binOr: {
                this.printer.print("|");
                break;
            }
            case binAnd: {
                this.printer.print("&");
                break;
            }
            case xor: {
                this.printer.print("^");
                break;
            }
            case equals: {
                this.printer.print("==");
                break;
            }
            case notEquals: {
                this.printer.print("!=");
                break;
            }
            case less: {
                this.printer.print("<");
                break;
            }
            case greater: {
                this.printer.print(">");
                break;
            }
            case lessEquals: {
                this.printer.print("<=");
                break;
            }
            case greaterEquals: {
                this.printer.print(">=");
                break;
            }
            case lShift: {
                this.printer.print("<<");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>");
                break;
            }
            case plus: {
                this.printer.print("+");
                break;
            }
            case minus: {
                this.printer.print("-");
                break;
            }
            case times: {
                this.printer.print("*");
                break;
            }
            case divide: {
                this.printer.print("/");
                break;
            }
            case remainder: {
                this.printer.print("%");
            }
        }
        this.printer.print(" ");
        n.getRight().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(CastExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("(");
        n.getType().accept(this, arg);
        this.printer.print(") ");
        n.getExpr().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ClassExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getType().accept(this, arg);
        this.printer.print(".class");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ConditionalExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getCondition().accept(this, arg);
        this.printer.print(" ? ");
        n.getThenExpr().accept(this, arg);
        this.printer.print(" : ");
        n.getElseExpr().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(EnclosedExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("(");
        n.getInner().accept(this, arg);
        this.printer.print(")");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(FieldAccessExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getScope().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getField());
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(InstanceOfExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getExpr().accept(this, arg);
        this.printer.print(" instanceof ");
        n.getType().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(CharLiteralExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("'");
        this.printer.print(n.getValue());
        this.printer.print("'");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(DoubleLiteralExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(n.getValue());
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(IntegerLiteralExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(n.getValue());
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(LongLiteralExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(n.getValue());
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(IntegerLiteralMinValueExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(n.getValue());
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(LongLiteralMinValueExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(n.getValue());
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(StringLiteralExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("\"");
        this.printer.print(n.getValue());
        this.printer.print("\"");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(BooleanLiteralExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(String.valueOf(n.getValue()));
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(NullLiteralExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("null");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ThisExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("this");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(SuperExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("super");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(MethodCallExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printTypeArgs(n.getTypeArgs(), arg);
        this.printer.print(n.getName());
        this.printArguments(n.getArgs(), arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(LambdaExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ObjectCreationExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("new ");
        this.printTypeArgs(n.getTypeArgs(), arg);
        n.getType().accept(this, arg);
        this.printArguments(n.getArgs(), arg);
        if (n.getAnonymousClassBody() != null) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(n.getAnonymousClassBody(), arg);
            this.printer.unindent();
            this.printer.print("}");
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(UnaryExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        switch (n.getOperator()) {
            case positive: {
                this.printer.print("+");
                break;
            }
            case negative: {
                this.printer.print("-");
                break;
            }
            case inverse: {
                this.printer.print("~");
                break;
            }
            case not: {
                this.printer.print("!");
                break;
            }
            case preIncrement: {
                this.printer.print("++");
                break;
            }
            case preDecrement: {
                this.printer.print("--");
            }
        }
        n.getExpr().accept(this, arg);
        switch (n.getOperator()) {
            case posIncrement: {
                this.printer.print("++");
                break;
            }
            case posDecrement: {
                this.printer.print("--");
            }
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ConstructorDeclaration n, Object arg) {
        Iterator<Node> i;
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printBeginComments(n.getBeginComments(), arg);
        this.printModifiers(n.getModifiers());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getTypeParameters() != null) {
            this.printer.print(" ");
        }
        this.printer.print(n.getName());
        this.printer.print("(");
        if (n.getParameters() != null) {
            i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        if (n.getThrows() != null) {
            this.printer.print(" throws ");
            i = n.getThrows().iterator();
            while (i.hasNext()) {
                NameExpr name = (NameExpr)i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(" ");
        n.getBlock().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(MethodDeclaration n, Object arg) {
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printBeginComments(n.getBeginComments(), arg);
        this.printModifiers(n.getModifiers());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getTypeParameters() != null) {
            this.printer.print(" ");
        }
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("(");
        if (n.getParameters() != null) {
            Iterator<Parameter> i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        for (int i = 0; i < n.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
        if (n.getThrows() != null) {
            this.printer.print(" throws ");
            Iterator<NameExpr> i = n.getThrows().iterator();
            while (i.hasNext()) {
                NameExpr name = i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getBody() == null) {
            this.printer.print(";");
        } else {
            this.printer.print(" ");
            n.getBody().accept(this, arg);
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(Parameter n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        if (n.isVarArgs()) {
            this.printer.print("...");
        }
        this.printer.print(" ");
        n.getId().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(CatchParameter n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getTypeList().get(0).accept(this, arg);
        for (int i = 1; i < n.getTypeList().size(); ++i) {
            this.printer.print(" | ");
            n.getTypeList().get(i).accept(this, arg);
        }
        this.printer.print(" ");
        n.getId().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(Resource n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        n.getId().accept(this, arg);
        this.printer.print(" = ");
        n.getExpression().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ExplicitConstructorInvocationStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        if (n.isThis()) {
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("this");
        } else {
            if (n.getExpr() != null) {
                n.getExpr().accept(this, arg);
                this.printer.print(".");
            }
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("super");
        }
        this.printArguments(n.getArgs(), arg);
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(VariableDeclarationExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVars().iterator();
        while (i.hasNext()) {
            VariableDeclarator v = i.next();
            v.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(TypeDeclarationStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getTypeDeclaration().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(AssertStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("assert ");
        n.getCheck().accept(this, arg);
        if (n.getMessage() != null) {
            this.printer.print(" : ");
            n.getMessage().accept(this, arg);
        }
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(BlockStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.printLn("{");
        this.printer.indent();
        this.printInternalComments(n.getInternalComments(), arg);
        this.printer.unindent();
        if (n.getStmts() != null) {
            this.printer.indent();
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
                this.printer.printLn();
            }
            this.printer.unindent();
        }
        this.printer.print("}");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(LabeledStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(n.getLabel());
        this.printer.print(": ");
        n.getStmt().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(EmptyStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ExpressionStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        n.getExpression().accept(this, arg);
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(SwitchStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("switch(");
        n.getSelector().accept(this, arg);
        this.printer.printLn(") {");
        if (n.getEntries() != null) {
            this.printer.indent();
            for (SwitchEntryStmt e : n.getEntries()) {
                e.accept(this, arg);
            }
            this.printer.unindent();
        }
        this.printer.print("}");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(SwitchEntryStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        if (n.getLabel() != null) {
            this.printer.print("case ");
            n.getLabel().accept(this, arg);
            this.printer.print(":");
        } else {
            this.printer.print("default:");
        }
        this.printer.printLn();
        this.printer.indent();
        if (n.getStmts() != null) {
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
                this.printer.printLn();
            }
        }
        this.printer.unindent();
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(BreakStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("break");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ReturnStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("return");
        if (n.getExpr() != null) {
            this.printer.print(" ");
            n.getExpr().accept(this, arg);
        }
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(EnumDeclaration n, Object arg) {
        Iterator<Node> i;
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printBeginComments(n.getBeginComments(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("enum ");
        this.printer.print(n.getName());
        if (n.getImplements() != null) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getEntries() != null) {
            this.printer.printLn();
            i = n.getEntries().iterator();
            while (i.hasNext()) {
                EnumConstantDeclaration e = (EnumConstantDeclaration)i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getMembers() != null) {
            this.printer.printLn(";");
            this.printMembers(n.getMembers(), arg);
        } else if (n.getEntries() != null) {
            this.printer.printLn();
        }
        this.printer.unindent();
        this.printer.print("}");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(EnumConstantDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(n.getName());
        if (n.getArgs() != null) {
            this.printArguments(n.getArgs(), arg);
        }
        if (n.getClassBody() != null) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(n.getClassBody(), arg);
            this.printer.unindent();
            this.printer.printLn("}");
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(EmptyMemberDeclaration n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(InitializerDeclaration n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getBlock().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(IfStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("if (");
        n.getCondition().accept(this, arg);
        this.printer.print(") ");
        n.getThenStmt().accept(this, arg);
        if (n.getElseStmt() != null) {
            this.printer.print(" else ");
            n.getElseStmt().accept(this, arg);
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(WhileStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("while (");
        n.getCondition().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ContinueStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("continue");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(DoStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("do ");
        n.getBody().accept(this, arg);
        this.printer.print(" while (");
        n.getCondition().accept(this, arg);
        this.printer.print(");");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ForeachStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("for (");
        n.getVariable().accept(this, arg);
        this.printer.print(" : ");
        n.getIterable().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ForStmt n, Object arg) {
        Expression e;
        Iterator<Expression> i;
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("for (");
        if (n.getInit() != null) {
            i = n.getInit().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print("; ");
        if (n.getCompare() != null) {
            n.getCompare().accept(this, arg);
        }
        this.printer.print("; ");
        if (n.getUpdate() != null) {
            i = n.getUpdate().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(") ");
        n.getBody().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(ThrowStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("throw ");
        n.getExpr().accept(this, arg);
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(SynchronizedStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("synchronized (");
        n.getExpr().accept(this, arg);
        this.printer.print(") ");
        n.getBlock().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(TryStmt n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("try ");
        if (n.getResources() != null && n.getResources().size() > 0) {
            this.printer.print("(");
            n.getResources().get(0).accept(this, arg);
            for (int i = 1; i < n.getResources().size(); ++i) {
                this.printer.print("; ");
                n.getResources().get(i).accept(this, arg);
            }
            this.printer.print(")");
        }
        n.getTryBlock().accept(this, arg);
        if (n.getCatchs() != null) {
            for (CatchClause c : n.getCatchs()) {
                c.accept(this, arg);
            }
        }
        if (n.getFinallyBlock() != null) {
            this.printer.print(" finally ");
            n.getFinallyBlock().accept(this, arg);
        }
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(CatchClause n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(" catch (");
        n.getExcept().accept(this, arg);
        this.printer.print(") ");
        n.getCatchBlock().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(AnnotationDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printBeginComments(n.getBeginComments(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("@interface ");
        this.printer.print(n.getName());
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getMembers() != null) {
            this.printMembers(n.getMembers(), arg);
        }
        this.printer.unindent();
        this.printer.print("}");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(AnnotationMemberDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printBeginComments(n.getBeginComments(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("()");
        if (n.getDefaultValue() != null) {
            this.printer.print(" default ");
            n.getDefaultValue().accept(this, arg);
        }
        this.printer.print(";");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(MarkerAnnotationExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(SingleMemberAnnotationExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        n.getMemberValue().accept(this, arg);
        this.printer.print(")");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(NormalAnnotationExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        if (n.getPairs() != null) {
            Iterator<MemberValuePair> i = n.getPairs().iterator();
            while (i.hasNext()) {
                MemberValuePair m = i.next();
                m.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(MemberValuePair n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printer.print(n.getName());
        this.printer.print(" = ");
        n.getValue().accept(this, arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    @Override
    public void visit(LineComment n, Object arg) {
    }

    @Override
    public void visit(BlockComment n, Object arg) {
    }

    @Override
    public void visit(Comment n, Object arg) {
    }

    private void printBeginComments(List<Comment> beginComments, Object arg) {
        if (beginComments == null) {
            return;
        }
        for (Comment comment : beginComments) {
            this.printComment(comment, this.printer.getLevel(), CommentFormatter.CommentLocation.BEGINNING);
        }
    }

    private void printInternalComments(List<Comment> internalComments, Object arg) {
        if (internalComments == null) {
            return;
        }
        for (Comment comment : internalComments) {
            this.printComment(comment, this.printer.getLevel(), CommentFormatter.CommentLocation.INTERNAL);
        }
    }

    private void printEndComments(List<Comment> endComments, Object arg) {
        if (endComments == null) {
            return;
        }
        for (Comment comment : endComments) {
            this.printComment(comment, 0, CommentFormatter.CommentLocation.END);
        }
    }

    private void printComment(Comment comment, int indentLevel, CommentFormatter.CommentLocation commentLocation) {
        if (comment == null || comment.getContent() == null) {
            return;
        }
        String commentAsString = commentFormatter.format(comment, indentLevel, commentLocation);
        boolean endsWithNewline = commentAsString.endsWith("\r\n") || commentAsString.endsWith("\n");
        this.printer.printRaw(commentAsString, !endsWithNewline);
    }

    @Override
    public void visit(MethodReferenceExpr n, Object arg) {
        this.printBeginComments(n.getBeginComments(), arg);
        this.printEndComments(n.getEndComments(), arg);
    }

    private static class SourcePrinter {
        private int level = 0;
        private boolean indented = false;
        private final StringBuilder buf = new StringBuilder();

        private SourcePrinter() {
        }

        public void indent() {
            ++this.level;
        }

        public void unindent() {
            --this.level;
        }

        private void makeIndent() {
            for (int i = 0; i < this.level; ++i) {
                this.buf.append("    ");
            }
        }

        public void print(String arg) {
            if (!this.indented) {
                this.makeIndent();
                this.indented = true;
            }
            this.buf.append(arg);
        }

        public void printRaw(String arg, boolean stillIndented) {
            this.buf.append(arg);
            this.indented = stillIndented;
        }

        public void printRaw(String arg) {
            this.buf.append(arg);
        }

        public void printLn(String arg) {
            this.print(arg);
            this.printLn();
        }

        public void printLn() {
            this.buf.append("\n");
            this.indented = false;
        }

        public String getSource() {
            return this.buf.toString();
        }

        public String toString() {
            return this.getSource();
        }

        public int getLevel() {
            return this.level;
        }
    }
}

