
/*
 * This file is part of antlr-java-parser.
 *
 *     antlr-java-parser is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     antlr-java-parser is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with antlr-java-parser.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.github.antlrjavaparser;

import org.antlr.v4.runtime.tree.ParseTreeListener;

public interface Java7ParserListener extends ParseTreeListener {
	void enterInnerCreator(Java7Parser.InnerCreatorContext ctx);
	void exitInnerCreator(Java7Parser.InnerCreatorContext ctx);

	void enterExpressionList(Java7Parser.ExpressionListContext ctx);
	void exitExpressionList(Java7Parser.ExpressionListContext ctx);

	void enterTypeDeclaration(Java7Parser.TypeDeclarationContext ctx);
	void exitTypeDeclaration(Java7Parser.TypeDeclarationContext ctx);

	void enterAnnotation(Java7Parser.AnnotationContext ctx);
	void exitAnnotation(Java7Parser.AnnotationContext ctx);

	void enterEnumConstant(Java7Parser.EnumConstantContext ctx);
	void exitEnumConstant(Java7Parser.EnumConstantContext ctx);

	void enterSwitchBlockStatementGroups(Java7Parser.SwitchBlockStatementGroupsContext ctx);
	void exitSwitchBlockStatementGroups(Java7Parser.SwitchBlockStatementGroupsContext ctx);

	void enterAnnotationHeader(Java7Parser.AnnotationHeaderContext ctx);
	void exitAnnotationHeader(Java7Parser.AnnotationHeaderContext ctx);

	void enterNormalClassDeclaration(Java7Parser.NormalClassDeclarationContext ctx);
	void exitNormalClassDeclaration(Java7Parser.NormalClassDeclarationContext ctx);

	void enterImportDeclaration(Java7Parser.ImportDeclarationContext ctx);
	void exitImportDeclaration(Java7Parser.ImportDeclarationContext ctx);

	void enterThisSuffix(Java7Parser.ThisSuffixContext ctx);
	void exitThisSuffix(Java7Parser.ThisSuffixContext ctx);

	void enterElementValuePairs(Java7Parser.ElementValuePairsContext ctx);
	void exitElementValuePairs(Java7Parser.ElementValuePairsContext ctx);

	void enterInterfaceMethodDeclaration(Java7Parser.InterfaceMethodDeclarationContext ctx);
	void exitInterfaceMethodDeclaration(Java7Parser.InterfaceMethodDeclarationContext ctx);

	void enterExclusiveOrExpression(Java7Parser.ExclusiveOrExpressionContext ctx);
	void exitExclusiveOrExpression(Java7Parser.ExclusiveOrExpressionContext ctx);

	void enterInstanceOfExpression(Java7Parser.InstanceOfExpressionContext ctx);
	void exitInstanceOfExpression(Java7Parser.InstanceOfExpressionContext ctx);

	void enterInterfaceBodyDeclaration(Java7Parser.InterfaceBodyDeclarationContext ctx);
	void exitInterfaceBodyDeclaration(Java7Parser.InterfaceBodyDeclarationContext ctx);

	void enterEnumConstants(Java7Parser.EnumConstantsContext ctx);
	void exitEnumConstants(Java7Parser.EnumConstantsContext ctx);

	void enterMarkerAnnotation(Java7Parser.MarkerAnnotationContext ctx);
	void exitMarkerAnnotation(Java7Parser.MarkerAnnotationContext ctx);

	void enterCatchClause(Java7Parser.CatchClauseContext ctx);
	void exitCatchClause(Java7Parser.CatchClauseContext ctx);

	void enterTryWithResources(Java7Parser.TryWithResourcesContext ctx);
	void exitTryWithResources(Java7Parser.TryWithResourcesContext ctx);

	void enterSingleElementAnnotation(Java7Parser.SingleElementAnnotationContext ctx);
	void exitSingleElementAnnotation(Java7Parser.SingleElementAnnotationContext ctx);

	void enterEnumBody(Java7Parser.EnumBodyContext ctx);
	void exitEnumBody(Java7Parser.EnumBodyContext ctx);

	void enterEnumDeclaration(Java7Parser.EnumDeclarationContext ctx);
	void exitEnumDeclaration(Java7Parser.EnumDeclarationContext ctx);

	void enterQualifiedImportName(Java7Parser.QualifiedImportNameContext ctx);
	void exitQualifiedImportName(Java7Parser.QualifiedImportNameContext ctx);

	void enterForeachStatement(Java7Parser.ForeachStatementContext ctx);
	void exitForeachStatement(Java7Parser.ForeachStatementContext ctx);

	void enterTypeParameter(Java7Parser.TypeParameterContext ctx);
	void exitTypeParameter(Java7Parser.TypeParameterContext ctx);

	void enterExplicitConstructorInvocation(Java7Parser.ExplicitConstructorInvocationContext ctx);
	void exitExplicitConstructorInvocation(Java7Parser.ExplicitConstructorInvocationContext ctx);

	void enterEnumBodyDeclarations(Java7Parser.EnumBodyDeclarationsContext ctx);
	void exitEnumBodyDeclarations(Java7Parser.EnumBodyDeclarationsContext ctx);

	void enterTypeBound(Java7Parser.TypeBoundContext ctx);
	void exitTypeBound(Java7Parser.TypeBoundContext ctx);

	void enterAnnotationMethodDeclaration(Java7Parser.AnnotationMethodDeclarationContext ctx);
	void exitAnnotationMethodDeclaration(Java7Parser.AnnotationMethodDeclarationContext ctx);

	void enterVariableInitializer(Java7Parser.VariableInitializerContext ctx);
	void exitVariableInitializer(Java7Parser.VariableInitializerContext ctx);

	void enterBlock(Java7Parser.BlockContext ctx);
	void exitBlock(Java7Parser.BlockContext ctx);

	void enterConditionalExpression(Java7Parser.ConditionalExpressionContext ctx);
	void exitConditionalExpression(Java7Parser.ConditionalExpressionContext ctx);

	void enterAndExpression(Java7Parser.AndExpressionContext ctx);
	void exitAndExpression(Java7Parser.AndExpressionContext ctx);

	void enterLocalVariableDeclarationStatement(Java7Parser.LocalVariableDeclarationStatementContext ctx);
	void exitLocalVariableDeclarationStatement(Java7Parser.LocalVariableDeclarationStatementContext ctx);

	void enterSuperSuffix(Java7Parser.SuperSuffixContext ctx);
	void exitSuperSuffix(Java7Parser.SuperSuffixContext ctx);

	void enterFieldDeclaration(Java7Parser.FieldDeclarationContext ctx);
	void exitFieldDeclaration(Java7Parser.FieldDeclarationContext ctx);

	void enterNormalInterfaceDeclaration(Java7Parser.NormalInterfaceDeclarationContext ctx);
	void exitNormalInterfaceDeclaration(Java7Parser.NormalInterfaceDeclarationContext ctx);

	void enterModifiers(Java7Parser.ModifiersContext ctx);
	void exitModifiers(Java7Parser.ModifiersContext ctx);

	void enterTypeHeader(Java7Parser.TypeHeaderContext ctx);
	void exitTypeHeader(Java7Parser.TypeHeaderContext ctx);

	void enterParExpression(Java7Parser.ParExpressionContext ctx);
	void exitParExpression(Java7Parser.ParExpressionContext ctx);

	void enterCatches(Java7Parser.CatchesContext ctx);
	void exitCatches(Java7Parser.CatchesContext ctx);

	void enterSwitchLabel(Java7Parser.SwitchLabelContext ctx);
	void exitSwitchLabel(Java7Parser.SwitchLabelContext ctx);

	void enterTypeParameters(Java7Parser.TypeParametersContext ctx);
	void exitTypeParameters(Java7Parser.TypeParametersContext ctx);

	void enterQualifiedName(Java7Parser.QualifiedNameContext ctx);
	void exitQualifiedName(Java7Parser.QualifiedNameContext ctx);

	void enterClassDeclaration(Java7Parser.ClassDeclarationContext ctx);
	void exitClassDeclaration(Java7Parser.ClassDeclarationContext ctx);

	void enterLocalVariableHeader(Java7Parser.LocalVariableHeaderContext ctx);
	void exitLocalVariableHeader(Java7Parser.LocalVariableHeaderContext ctx);

	void enterTrystatement(Java7Parser.TrystatementContext ctx);
	void exitTrystatement(Java7Parser.TrystatementContext ctx);

	void enterInclusiveOrExpression(Java7Parser.InclusiveOrExpressionContext ctx);
	void exitInclusiveOrExpression(Java7Parser.InclusiveOrExpressionContext ctx);

	void enterArguments(Java7Parser.ArgumentsContext ctx);
	void exitArguments(Java7Parser.ArgumentsContext ctx);

	void enterEqualityExpression(Java7Parser.EqualityExpressionContext ctx);
	void exitEqualityExpression(Java7Parser.EqualityExpressionContext ctx);

	void enterFormalParameters(Java7Parser.FormalParametersContext ctx);
	void exitFormalParameters(Java7Parser.FormalParametersContext ctx);

	void enterCastExpression(Java7Parser.CastExpressionContext ctx);
	void exitCastExpression(Java7Parser.CastExpressionContext ctx);

	void enterInterfaceHeader(Java7Parser.InterfaceHeaderContext ctx);
	void exitInterfaceHeader(Java7Parser.InterfaceHeaderContext ctx);

	void enterTypeArgument(Java7Parser.TypeArgumentContext ctx);
	void exitTypeArgument(Java7Parser.TypeArgumentContext ctx);

	void enterAnnotations(Java7Parser.AnnotationsContext ctx);
	void exitAnnotations(Java7Parser.AnnotationsContext ctx);

	void enterForInit(Java7Parser.ForInitContext ctx);
	void exitForInit(Java7Parser.ForInitContext ctx);

	void enterSelector(Java7Parser.SelectorContext ctx);
	void exitSelector(Java7Parser.SelectorContext ctx);

	void enterVariableDeclarator(Java7Parser.VariableDeclaratorContext ctx);
	void exitVariableDeclarator(Java7Parser.VariableDeclaratorContext ctx);

	void enterAnnotationTypeDeclaration(Java7Parser.AnnotationTypeDeclarationContext ctx);
	void exitAnnotationTypeDeclaration(Java7Parser.AnnotationTypeDeclarationContext ctx);

	void enterExpression(Java7Parser.ExpressionContext ctx);
	void exitExpression(Java7Parser.ExpressionContext ctx);

	void enterResources(Java7Parser.ResourcesContext ctx);
	void exitResources(Java7Parser.ResourcesContext ctx);

	void enterRelationalOp(Java7Parser.RelationalOpContext ctx);
	void exitRelationalOp(Java7Parser.RelationalOpContext ctx);

	void enterUnaryExpression(Java7Parser.UnaryExpressionContext ctx);
	void exitUnaryExpression(Java7Parser.UnaryExpressionContext ctx);

	void enterType(Java7Parser.TypeContext ctx);
	void exitType(Java7Parser.TypeContext ctx);

	void enterAdditiveOp(Java7Parser.AdditiveOpContext ctx);
	void exitAdditiveOp(Java7Parser.AdditiveOpContext ctx);

	void enterInterfaceFieldDeclaration(Java7Parser.InterfaceFieldDeclarationContext ctx);
	void exitInterfaceFieldDeclaration(Java7Parser.InterfaceFieldDeclarationContext ctx);

	void enterMemberDecl(Java7Parser.MemberDeclContext ctx);
	void exitMemberDecl(Java7Parser.MemberDeclContext ctx);

	void enterElementValueArrayInitializer(Java7Parser.ElementValueArrayInitializerContext ctx);
	void exitElementValueArrayInitializer(Java7Parser.ElementValueArrayInitializerContext ctx);

	void enterClassHeader(Java7Parser.ClassHeaderContext ctx);
	void exitClassHeader(Java7Parser.ClassHeaderContext ctx);

	void enterPrimary(Java7Parser.PrimaryContext ctx);
	void exitPrimary(Java7Parser.PrimaryContext ctx);

	void enterEllipsisParameterDecl(Java7Parser.EllipsisParameterDeclContext ctx);
	void exitEllipsisParameterDecl(Java7Parser.EllipsisParameterDeclContext ctx);

	void enterNormalParameterDecl(Java7Parser.NormalParameterDeclContext ctx);
	void exitNormalParameterDecl(Java7Parser.NormalParameterDeclContext ctx);

	void enterShiftExpression(Java7Parser.ShiftExpressionContext ctx);
	void exitShiftExpression(Java7Parser.ShiftExpressionContext ctx);

	void enterIdentifierSuffix(Java7Parser.IdentifierSuffixContext ctx);
	void exitIdentifierSuffix(Java7Parser.IdentifierSuffixContext ctx);

	void enterClassBody(Java7Parser.ClassBodyContext ctx);
	void exitClassBody(Java7Parser.ClassBodyContext ctx);

	void enterConstructorBlock(Java7Parser.ConstructorBlockContext ctx);
	void exitConstructorBlock(Java7Parser.ConstructorBlockContext ctx);

	void enterCreatedName(Java7Parser.CreatedNameContext ctx);
	void exitCreatedName(Java7Parser.CreatedNameContext ctx);

	void enterInterfaceDeclaration(Java7Parser.InterfaceDeclarationContext ctx);
	void exitInterfaceDeclaration(Java7Parser.InterfaceDeclarationContext ctx);

	void enterPackageDeclaration(Java7Parser.PackageDeclarationContext ctx);
	void exitPackageDeclaration(Java7Parser.PackageDeclarationContext ctx);

	void enterConditionalAndExpression(Java7Parser.ConditionalAndExpressionContext ctx);
	void exitConditionalAndExpression(Java7Parser.ConditionalAndExpressionContext ctx);

	void enterAdditiveExpression(Java7Parser.AdditiveExpressionContext ctx);
	void exitAdditiveExpression(Java7Parser.AdditiveExpressionContext ctx);

	void enterTypeArguments(Java7Parser.TypeArgumentsContext ctx);
	void exitTypeArguments(Java7Parser.TypeArgumentsContext ctx);

	void enterClassCreatorRest(Java7Parser.ClassCreatorRestContext ctx);
	void exitClassCreatorRest(Java7Parser.ClassCreatorRestContext ctx);

	void enterArrayCreator(Java7Parser.ArrayCreatorContext ctx);
	void exitArrayCreator(Java7Parser.ArrayCreatorContext ctx);

	void enterCatchFormalParameter(Java7Parser.CatchFormalParameterContext ctx);
	void exitCatchFormalParameter(Java7Parser.CatchFormalParameterContext ctx);

	void enterEmptyStatement(Java7Parser.EmptyStatementContext ctx);
	void exitEmptyStatement(Java7Parser.EmptyStatementContext ctx);

	void enterModifier(Java7Parser.ModifierContext ctx);
	void exitModifier(Java7Parser.ModifierContext ctx);

	void enterStatement(Java7Parser.StatementContext ctx);
	void exitStatement(Java7Parser.StatementContext ctx);

	void enterInterfaceBody(Java7Parser.InterfaceBodyContext ctx);
	void exitInterfaceBody(Java7Parser.InterfaceBodyContext ctx);

	void enterClassBodyDeclaration(Java7Parser.ClassBodyDeclarationContext ctx);
	void exitClassBodyDeclaration(Java7Parser.ClassBodyDeclarationContext ctx);

	void enterTypeList(Java7Parser.TypeListContext ctx);
	void exitTypeList(Java7Parser.TypeListContext ctx);

	void enterLocalVariableDeclaration(Java7Parser.LocalVariableDeclarationContext ctx);
	void exitLocalVariableDeclaration(Java7Parser.LocalVariableDeclarationContext ctx);

	void enterMultiplicativeExpression(Java7Parser.MultiplicativeExpressionContext ctx);
	void exitMultiplicativeExpression(Java7Parser.MultiplicativeExpressionContext ctx);

	void enterAssignmentOperator(Java7Parser.AssignmentOperatorContext ctx);
	void exitAssignmentOperator(Java7Parser.AssignmentOperatorContext ctx);

	void enterShiftOp(Java7Parser.ShiftOpContext ctx);
	void exitShiftOp(Java7Parser.ShiftOpContext ctx);

	void enterCompilationUnit(Java7Parser.CompilationUnitContext ctx);
	void exitCompilationUnit(Java7Parser.CompilationUnitContext ctx);

	void enterElementValue(Java7Parser.ElementValueContext ctx);
	void exitElementValue(Java7Parser.ElementValueContext ctx);

	void enterClassOrInterfaceType(Java7Parser.ClassOrInterfaceTypeContext ctx);
	void exitClassOrInterfaceType(Java7Parser.ClassOrInterfaceTypeContext ctx);

	void enterUnaryExpressionNotPlusMinus(Java7Parser.UnaryExpressionNotPlusMinusContext ctx);
	void exitUnaryExpressionNotPlusMinus(Java7Parser.UnaryExpressionNotPlusMinusContext ctx);

	void enterAnnotationTypeElementDeclaration(Java7Parser.AnnotationTypeElementDeclarationContext ctx);
	void exitAnnotationTypeElementDeclaration(Java7Parser.AnnotationTypeElementDeclarationContext ctx);

	void enterBlockStatement(Java7Parser.BlockStatementContext ctx);
	void exitBlockStatement(Java7Parser.BlockStatementContext ctx);

	void enterAnnotationTypeBody(Java7Parser.AnnotationTypeBodyContext ctx);
	void exitAnnotationTypeBody(Java7Parser.AnnotationTypeBodyContext ctx);

	void enterCreator(Java7Parser.CreatorContext ctx);
	void exitCreator(Java7Parser.CreatorContext ctx);

	void enterQualifiedNameList(Java7Parser.QualifiedNameListContext ctx);
	void exitQualifiedNameList(Java7Parser.QualifiedNameListContext ctx);

	void enterMultiplicativeOp(Java7Parser.MultiplicativeOpContext ctx);
	void exitMultiplicativeOp(Java7Parser.MultiplicativeOpContext ctx);

	void enterFormalParameterDecls(Java7Parser.FormalParameterDeclsContext ctx);
	void exitFormalParameterDecls(Java7Parser.FormalParameterDeclsContext ctx);

	void enterNormalAnnotation(Java7Parser.NormalAnnotationContext ctx);
	void exitNormalAnnotation(Java7Parser.NormalAnnotationContext ctx);

	void enterRelationalExpression(Java7Parser.RelationalExpressionContext ctx);
	void exitRelationalExpression(Java7Parser.RelationalExpressionContext ctx);

	void enterConditionalOrExpression(Java7Parser.ConditionalOrExpressionContext ctx);
	void exitConditionalOrExpression(Java7Parser.ConditionalOrExpressionContext ctx);

	void enterForstatement(Java7Parser.ForstatementContext ctx);
	void exitForstatement(Java7Parser.ForstatementContext ctx);

	void enterIdentifierTypeArgument(Java7Parser.IdentifierTypeArgumentContext ctx);
	void exitIdentifierTypeArgument(Java7Parser.IdentifierTypeArgumentContext ctx);

	void enterEnumHeader(Java7Parser.EnumHeaderContext ctx);
	void exitEnumHeader(Java7Parser.EnumHeaderContext ctx);

	void enterMethodDeclaration(Java7Parser.MethodDeclarationContext ctx);
	void exitMethodDeclaration(Java7Parser.MethodDeclarationContext ctx);

	void enterResourceSpecification(Java7Parser.ResourceSpecificationContext ctx);
	void exitResourceSpecification(Java7Parser.ResourceSpecificationContext ctx);

	void enterConstructorDeclaration(Java7Parser.ConstructorDeclarationContext ctx);
	void exitConstructorDeclaration(Java7Parser.ConstructorDeclarationContext ctx);

	void enterResource(Java7Parser.ResourceContext ctx);
	void exitResource(Java7Parser.ResourceContext ctx);

	void enterElementValuePair(Java7Parser.ElementValuePairContext ctx);
	void exitElementValuePair(Java7Parser.ElementValuePairContext ctx);

	void enterNormalForStatement(Java7Parser.NormalForStatementContext ctx);
	void exitNormalForStatement(Java7Parser.NormalForStatementContext ctx);

	void enterNotEqualityExpression(Java7Parser.NotEqualityExpressionContext ctx);
	void exitNotEqualityExpression(Java7Parser.NotEqualityExpressionContext ctx);

	void enterMethodHeader(Java7Parser.MethodHeaderContext ctx);
	void exitMethodHeader(Java7Parser.MethodHeaderContext ctx);

	void enterArrayInitializer(Java7Parser.ArrayInitializerContext ctx);
	void exitArrayInitializer(Java7Parser.ArrayInitializerContext ctx);

	void enterPrimitiveType(Java7Parser.PrimitiveTypeContext ctx);
	void exitPrimitiveType(Java7Parser.PrimitiveTypeContext ctx);

	void enterVariableModifiers(Java7Parser.VariableModifiersContext ctx);
	void exitVariableModifiers(Java7Parser.VariableModifiersContext ctx);

	void enterNonWildcardTypeArguments(Java7Parser.NonWildcardTypeArgumentsContext ctx);
	void exitNonWildcardTypeArguments(Java7Parser.NonWildcardTypeArgumentsContext ctx);

	void enterFieldHeader(Java7Parser.FieldHeaderContext ctx);
	void exitFieldHeader(Java7Parser.FieldHeaderContext ctx);

	void enterClassOrInterfaceDeclaration(Java7Parser.ClassOrInterfaceDeclarationContext ctx);
	void exitClassOrInterfaceDeclaration(Java7Parser.ClassOrInterfaceDeclarationContext ctx);

	void enterLiteral(Java7Parser.LiteralContext ctx);
	void exitLiteral(Java7Parser.LiteralContext ctx);

	void enterSwitchBlockStatementGroup(Java7Parser.SwitchBlockStatementGroupContext ctx);
	void exitSwitchBlockStatementGroup(Java7Parser.SwitchBlockStatementGroupContext ctx);
}