/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.HttpServerExchange;
import httpserver.util.Encoding;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class FormData {
    private final Map<String, String> fields;

    public static FormData parseForm(HttpServerExchange exchange, Charset charset) throws IOException {
        String type = exchange.getRequestHeader("Content-Type");
        if ("application/x-www-form-urlencoded".equals(type)) {
            String[] fields;
            HashMap<String, String> map = new HashMap<String, String>();
            for (String paramPair : fields = new String(exchange.getInputStream().readAllBytes(), charset).split("&")) {
                int equalsOffset = paramPair.indexOf(61);
                if (equalsOffset == -1) {
                    map.put(paramPair, "");
                    continue;
                }
                String paramName = Encoding.decodeUrl(paramPair.substring(0, equalsOffset));
                String paramValue = Encoding.decodeUrl(paramPair.substring(equalsOffset + 1));
                map.put(paramName, paramValue);
            }
            return new FormData(map);
        }
        if ("multipart/form-data".equals(type)) {
            throw new IOException("Multipart form parsing not supported");
        }
        throw new IOException("Request body contains unknown form type: " + type);
    }

    private FormData(Map<String, String> fields) {
        this.fields = fields;
    }

    public String get(String parameter) {
        return this.fields.get(parameter);
    }
}

