/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import java.util.Map;

public final class StatusCode
extends Enum<StatusCode> {
    public static final int CONTINUE = 101;
    public static final int OK = 200;
    public static final int CREATED = 201;
    public static final int ACCEPTED = 202;
    public static final int NO_CONTENT = 204;
    public static final int RESET_CONTENT = 205;
    public static final int PARTIAL_CONTENT = 206;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int FOUND = 302;
    public static final int SEE_OTHER = 303;
    public static final int NOT_MODIFIED = 304;
    public static final int USE_PROXY = 305;
    public static final int TEMPORARY_REDIRECT = 307;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int REQUEST_TIMEOUT = 408;
    public static final int CONFLICT = 409;
    public static final int GONE = 410;
    public static final int LENGTH_REQUIRED = 411;
    public static final int PRECONDITION_FAILED = 412;
    public static final int REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int REQUEST_URI_TOO_LONG = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int EXPECTATION_FAILED = 417;
    public static final int PRECONDITION_REQUIRED = 428;
    public static final int TOO_MANY_REQUESTS = 429;
    public static final int REQUEST_HEADER_FIELDS_TOO_LARGE = 431;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final int NETWORK_AUTHENTICATION_REQUIRED = 511;
    public static final String MESSAGE_CONTINUE = "Continue";
    public static final String MESSAGE_OK = "Ok";
    public static final String MESSAGE_CREATED = "Created";
    public static final String MESSAGE_ACCEPTED = "Acceptd";
    public static final String MESSAGE_NO_CONTENT = "No Content";
    public static final String MESSAGE_RESET_CONTENT = "Reset Content";
    public static final String MESSAGE_PARTIAL_CONTENT = "Partial Content";
    public static final String MESSAGE_MOVED_PERMANENTLY = "Moved Permanently";
    public static final String MESSAGE_FOUND = "Found";
    public static final String MESSAGE_SEE_OTHER = "See Other";
    public static final String MESSAGE_NOT_MODIFIED = "Not Modified";
    public static final String MESSAGE_USE_PROXY = "Use Proxy";
    public static final String MESSAGE_TEMPORARY_REDIRECT = "Temporary Redirect";
    public static final String MESSAGE_BAD_REQUEST = "Bad Request";
    public static final String MESSAGE_UNAUTHORIZED = "Unauthorized";
    public static final String MESSAGE_PAYMENT_REQUIRED = "Payment Required";
    public static final String MESSAGE_FORBIDDEN = "Forbidden";
    public static final String MESSAGE_NOT_FOUND = "Not Found";
    public static final String MESSAGE_METHOD_NOT_ALLOWED = "Method Not Allowed";
    public static final String MESSAGE_NOT_ACCEPTABLE = "Not Acceptable";
    public static final String MESSAGE_PROXY_AUTHENTICATION_REQUIRED = "Proxy Authentication Required";
    public static final String MESSAGE_REQUEST_TIMEOUT = "Request Timeout";
    public static final String MESSAGE_CONFLICT = "Conflict";
    public static final String MESSAGE_GONE = "Gone";
    public static final String MESSAGE_LENGTH_REQUIRED = "Length Required";
    public static final String MESSAGE_PRECONDITION_FAILED = "Precondition Failed";
    public static final String MESSAGE_REQUEST_ENTITY_TOO_LARGE = "Request Entity Too Large";
    public static final String MESSAGE_REQUEST_URI_TOO_LONG = "Request-URI Too Long";
    public static final String MESSAGE_UNSUPPORTED_MEDIA_TYPE = "Unsupported Media Type";
    public static final String MESSAGE_REQUESTED_RANGE_NOT_SATISFIABLE = "Requested Range Not Satisfiable";
    public static final String MESSAGE_EXPECTATION_FAILED = "Expectation Failed";
    public static final String MESSAGE_PRECONDITION_REQUIRED = "Precondition Required";
    public static final String MESSAGE_TOO_MANY_REQUESTS = "Too Many Requests";
    public static final String MESSAGE_REQUEST_HEADER_FIELDS_TOO_LARGE = "Request Header Fields Too Large";
    public static final String MESSAGE_INTERNAL_SERVER_ERROR = "Internal Server Error";
    public static final String MESSAGE_NOT_IMPLEMENTED = "Not Implemented";
    public static final String MESSAGE_BAD_GATEWAY = "Bad Gateway";
    public static final String MESSAGE_SERVICE_UNAVAILABLE = "Service Unavailable";
    public static final String MESSAGE_GATEWAY_TIMEOUT = "Gateway Timeout";
    public static final String MESSAGE_HTTP_VERSION_NOT_SUPPORTED = "HTTP Version Not Supported";
    public static final String MESSAGE_NETWORK_AUTHENTICATION_REQUIRED = "Network Authentication Required";
    private static final Map<Integer, String> codeToMessage;
    private static final /* synthetic */ StatusCode[] $VALUES;

    public static StatusCode[] values() {
        return (StatusCode[])$VALUES.clone();
    }

    public static StatusCode valueOf(String name) {
        return Enum.valueOf(StatusCode.class, name);
    }

    public static String getMessageForCode(int statusCode, String statusMessage) {
        if (statusMessage != null) {
            return statusMessage;
        }
        return codeToMessage.getOrDefault(statusCode, MESSAGE_NOT_IMPLEMENTED);
    }

    private static /* synthetic */ StatusCode[] $values() {
        return new StatusCode[0];
    }

    static {
        $VALUES = StatusCode.$values();
        codeToMessage = Map.ofEntries(Map.entry(101, MESSAGE_CONTINUE), Map.entry(200, MESSAGE_OK), Map.entry(201, MESSAGE_CREATED), Map.entry(202, MESSAGE_ACCEPTED), Map.entry(204, MESSAGE_NO_CONTENT), Map.entry(205, MESSAGE_RESET_CONTENT), Map.entry(206, MESSAGE_PARTIAL_CONTENT), Map.entry(301, MESSAGE_MOVED_PERMANENTLY), Map.entry(302, MESSAGE_FOUND), Map.entry(303, MESSAGE_SEE_OTHER), Map.entry(304, MESSAGE_NOT_MODIFIED), Map.entry(305, MESSAGE_USE_PROXY), Map.entry(307, MESSAGE_TEMPORARY_REDIRECT), Map.entry(400, MESSAGE_BAD_REQUEST), Map.entry(401, MESSAGE_UNAUTHORIZED), Map.entry(402, MESSAGE_PAYMENT_REQUIRED), Map.entry(403, MESSAGE_FORBIDDEN), Map.entry(404, MESSAGE_NOT_FOUND), Map.entry(405, MESSAGE_METHOD_NOT_ALLOWED), Map.entry(406, MESSAGE_NOT_ACCEPTABLE), Map.entry(407, MESSAGE_PROXY_AUTHENTICATION_REQUIRED), Map.entry(408, MESSAGE_REQUEST_TIMEOUT), Map.entry(409, MESSAGE_CONFLICT), Map.entry(410, MESSAGE_GONE), Map.entry(411, MESSAGE_LENGTH_REQUIRED), Map.entry(412, MESSAGE_PRECONDITION_FAILED), Map.entry(413, MESSAGE_REQUEST_ENTITY_TOO_LARGE), Map.entry(414, MESSAGE_REQUEST_URI_TOO_LONG), Map.entry(415, MESSAGE_UNSUPPORTED_MEDIA_TYPE), Map.entry(416, MESSAGE_REQUESTED_RANGE_NOT_SATISFIABLE), Map.entry(417, MESSAGE_EXPECTATION_FAILED), Map.entry(428, MESSAGE_PRECONDITION_REQUIRED), Map.entry(429, MESSAGE_TOO_MANY_REQUESTS), Map.entry(431, MESSAGE_REQUEST_HEADER_FIELDS_TOO_LARGE), Map.entry(500, MESSAGE_INTERNAL_SERVER_ERROR), Map.entry(501, MESSAGE_NOT_IMPLEMENTED), Map.entry(502, MESSAGE_BAD_GATEWAY), Map.entry(503, MESSAGE_SERVICE_UNAVAILABLE), Map.entry(504, MESSAGE_GATEWAY_TIMEOUT), Map.entry(505, MESSAGE_HTTP_VERSION_NOT_SUPPORTED), Map.entry(511, MESSAGE_NETWORK_AUTHENTICATION_REQUIRED));
    }
}

