/*
 * Decompiled with CFR 0.152.
 */
package httpserver.handlers;

import httpserver.HttpHandler;
import httpserver.core.HttpServerExchange;
import httpserver.util.Functions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public final class Compression
extends Enum<Compression> {
    private static final /* synthetic */ Compression[] $VALUES;

    public static Compression[] values() {
        return (Compression[])$VALUES.clone();
    }

    public static Compression valueOf(String name) {
        return Enum.valueOf(Compression.class, name);
    }

    public static HttpHandler compress(HttpHandler next) {
        return exchange -> {
            next.handleRequest(exchange);
            if (!exchange.isResponseSent()) {
                if (Compression.acceptsEncoding(exchange, "gzip")) {
                    Compression.compressGzip(exchange);
                } else if (Compression.acceptsEncoding(exchange, "deflate")) {
                    Compression.compressDeflate(exchange);
                }
            }
        };
    }

    public static HttpHandler compressGzip(HttpHandler next) {
        return exchange -> {
            next.handleRequest(exchange);
            if (!exchange.isResponseSent() && Compression.acceptsEncoding(exchange, "gzip")) {
                Compression.compressGzip(exchange);
            }
        };
    }

    public static HttpHandler compressDeflate(HttpHandler next) {
        return exchange -> {
            next.handleRequest(exchange);
            if (!exchange.isResponseSent() && Compression.acceptsEncoding(exchange, "deflate")) {
                Compression.compressDeflate(exchange);
            }
        };
    }

    public static void compressGzip(HttpServerExchange exchange) throws IOException {
        exchange.setResponseHeader("Content-Encoding", "gzip");
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                exchange.getResponseBody().writeTo(gzip);
            }
            exchange.send(out.toByteArray());
        }
    }

    public static void compressDeflate(HttpServerExchange exchange) throws IOException {
        exchange.setResponseHeader("Content-Encoding", "deflate");
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (DeflaterOutputStream deflate = new DeflaterOutputStream(out);){
                exchange.getResponseBody().writeTo(deflate);
            }
            exchange.send(out.toByteArray());
        }
    }

    public static boolean acceptsEncoding(HttpServerExchange exchange, String encoding) {
        String acceptedEncodings = exchange.getRequestHeader("Accept-Encoding");
        if (Functions.isNullOrEmpty(acceptedEncodings)) {
            return false;
        }
        for (String accepted : acceptedEncodings.split(",")) {
            if (Functions.isNullOrEmpty(accepted) || !encoding.equals(accepted.trim())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ Compression[] $values() {
        return new Compression[0];
    }

    static {
        $VALUES = Compression.$values();
    }
}

