/*
 * Decompiled with CFR 0.152.
 */
package httpserver.util;

import java.io.IOException;
import java.io.InputStream;

public class LengthRestrictedInputStream
extends InputStream {
    private final InputStream in;
    private long toRead;

    public LengthRestrictedInputStream(InputStream in, long length) {
        this.in = in;
        this.toRead = length;
    }

    @Override
    public int available() throws IOException {
        if (this.toRead <= 0L) {
            return 0;
        }
        return Math.min(this.in.available(), (int)this.toRead);
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        if (this.toRead <= 0L) {
            return -1;
        }
        int bytesToRead = (int)Math.min(Math.min((long)buffer.length, this.toRead), 8192L);
        int bytesRead = this.in.read(buffer, 0, bytesToRead);
        this.toRead -= (long)bytesToRead;
        return bytesRead;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.toRead <= 0L) {
            return -1;
        }
        int bytesToRead = Math.min((int)Math.min(Math.min((long)buffer.length, this.toRead), 8192L), length);
        int bytesRead = this.in.read(buffer, offset, bytesToRead);
        this.toRead -= (long)bytesToRead;
        return bytesRead;
    }

    @Override
    public int read() throws IOException {
        if (this.toRead <= 0L) {
            return -1;
        }
        --this.toRead;
        return this.in.read();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.toRead <= 0L) {
            return 0L;
        }
        long bytesToSkip = Math.min(n, this.toRead);
        long skipped = this.in.skip(bytesToSkip);
        this.toRead -= skipped;
        return skipped;
    }
}

